/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.api.AssetStorage;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;

public interface BlueMapMap {
    public String getId();

    public String getName();

    public BlueMapWorld getWorld();

    public AssetStorage getAssetStorage();

    public Map<String, MarkerSet> getMarkerSets();

    public Vector2i getTileSize();

    public Vector2i getTileOffset();

    @ApiStatus.Experimental
    public void setTileFilter(Predicate<Vector2i> var1);

    public void setFrozen(boolean var1);

    public boolean isFrozen();

    @ApiStatus.Experimental
    public Predicate<Vector2i> getTileFilter();

    default public Vector2i posToTile(double blockX, double blockZ) {
        Vector2i offset = this.getTileOffset();
        Vector2i size = this.getTileSize();
        return new Vector2i((int)Math.floor((blockX - (double)offset.getX()) / (double)size.getX()), (int)Math.floor((blockZ - (double)offset.getY()) / (double)size.getY()));
    }

    default public Vector2i posToTile(Vector3i pos) {
        return this.posToTile(pos.getX(), pos.getZ());
    }

    default public Vector2i posToTile(Vector3d pos) {
        return this.posToTile(pos.getX(), pos.getZ());
    }
}

