/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.fakelevel;

import com.ldtteam.common.fakelevel.FakeLevel;
import com.ldtteam.common.fakelevel.FakeLevelChunkSection;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.TickContainerAccess;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class FakeChunk
extends LevelChunk {
    private final FakeLevel<?> fakeLevel;
    int lastY;
    LevelChunkSection lastSection = null;

    public FakeChunk(FakeLevel<?> worldIn, int x, int z) {
        super(worldIn, new ChunkPos(x, z));
        this.fakeLevel = worldIn;
        this.fakeLevel.lastX = x;
        this.fakeLevel.lastZ = z;
        this.fakeLevel.lastChunk = this;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.fakeLevel.getBlockState(pos);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos, LevelChunk.EntityCreationType creationMode) {
        return this.fakeLevel.getBlockEntity(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.fakeLevel.getFluidState(pos);
    }

    public FluidState getFluidState(int bx, int by, int bz) {
        return this.getFluidState(new BlockPos(bx, by, bz));
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        return this.fakeLevel.getNoiseBiome(x, y, z);
    }

    public Map<BlockPos, BlockEntity> getBlockEntities() {
        return this.fakeLevel.blockEntities;
    }

    public Set<BlockPos> getBlockEntitiesPos() {
        return this.getBlockEntities().keySet();
    }

    public ModelData getModelData(BlockPos pos) {
        return this.fakeLevel.getModelData(pos);
    }

    public FullChunkStatus getFullStatus() {
        return FullChunkStatus.FULL;
    }

    public ChunkStatus getPersistedStatus() {
        return ChunkStatus.FULL;
    }

    public boolean isUnsaved() {
        return false;
    }

    public boolean isUpgrading() {
        return false;
    }

    public boolean isLightCorrect() {
        return true;
    }

    public int getHeight(Heightmap.Types type, int x, int z) {
        return this.fakeLevel.getHeight(type, this.chunkPos.getBlockX(x), this.chunkPos.getBlockZ(z));
    }

    public Collection<Map.Entry<Heightmap.Types, Heightmap>> getHeightmaps() {
        return Collections.emptyList();
    }

    public Heightmap getOrCreateHeightmapUnprimed(Heightmap.Types p_62079_) {
        return null;
    }

    public boolean hasPrimedHeightmap(Heightmap.Types p_187659_) {
        return false;
    }

    public void findBlocks(Predicate<BlockState> filter, BiPredicate<BlockState, BlockPos> fineFilter, BiConsumer<BlockPos, BlockState> sink) {
        for (BlockPos mutablePos : BlockPos.betweenClosed((int)this.chunkPos.getBlockX(0), (int)this.fakeLevel.levelSource.getMinBuildHeight(), (int)this.chunkPos.getBlockZ(0), (int)Math.min(this.chunkPos.getBlockX(15), this.fakeLevel.levelSource.getMaxX() - 1), (int)(this.fakeLevel.levelSource.getMaxBuildHeight() - 1), (int)Math.min(this.chunkPos.getBlockZ(15), this.fakeLevel.levelSource.getMaxZ() - 1))) {
            BlockState blockState = this.getBlockState(mutablePos);
            if (!fineFilter.test(blockState, mutablePos)) continue;
            sink.accept(mutablePos, blockState);
        }
    }

    public boolean isYSpaceEmpty(int p_62075_, int p_62076_) {
        return false;
    }

    public LevelChunkSection[] getSections() {
        return new LevelChunkSection[0];
    }

    public LevelChunkSection getSection(int yIdx) {
        if (this.lastY == yIdx && this.lastSection != null) {
            return this.lastSection;
        }
        return new FakeLevelChunkSection(this, yIdx);
    }

    public void addAndRegisterBlockEntity(BlockEntity p_156391_) {
    }

    public TickContainerAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyContainer();
    }

    public TickContainerAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyContainer();
    }

    public void postProcessGeneration() {
    }

    public void registerAllBlockEntitiesAfterLevelLoad() {
    }

    public void removeBlockEntity(BlockPos p_62919_) {
    }

    public void replaceBiomes(FriendlyByteBuf p_275574_) {
    }

    public void replaceWithPacketData(FriendlyByteBuf p_187972_, CompoundTag p_187973_, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> p_187974_) {
    }

    public void setBlockEntity(BlockEntity p_156374_) {
    }

    @javax.annotation.Nullable
    public BlockState setBlockState(BlockPos p_62865_, BlockState p_62866_, boolean p_62867_) {
        return null;
    }

    public void setFullStatus(Supplier<FullChunkStatus> p_62880_) {
    }

    public void unpackTicks(long p_187986_) {
    }

    public void addPackedPostProcess(short p_62092_, int p_62093_) {
    }

    public void addReferenceForStructure(Structure p_223007_, long p_223008_) {
    }

    public void fillBiomesFromNoise(BiomeResolver p_187638_, Climate.Sampler p_187639_) {
    }

    @javax.annotation.Nullable
    public CompoundTag getBlockEntityNbt(BlockPos p_62103_) {
        return null;
    }

    public void setAllReferences(Map<Structure, LongSet> p_187663_) {
    }

    public void setAllStarts(Map<Structure, StructureStart> p_62090_) {
    }

    public void setBlendingData(BlendingData p_187646_) {
    }

    public void setBlockEntityNbt(CompoundTag p_62091_) {
    }

    public void setLightCorrect(boolean p_62100_) {
    }

    public void setStartForStructure(Structure p_223010_, StructureStart p_223011_) {
    }

    public void setUnsaved(boolean p_62094_) {
    }

    public void setHeightmap(Heightmap.Types p_62083_, long[] p_62084_) {
    }
}

