/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.mod.item;

import com.ldtteam.blockui.mod.Log;
import com.ldtteam.common.util.BlockToItemHelper;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public record BlockStateRenderingData(BlockState blockState, @Nullable BlockEntity blockEntity, ModelData modelData, boolean modelNeedsRotationFix, Lazy<ItemStack> playerPickedItemStack) {
    private final ModelData modelData;
    public static final BlockPos ILLEGAL_BLOCK_ENTITY_POS = BlockPos.ZERO.below(1000);

    private BlockStateRenderingData(BlockState blockState, BlockEntity blockEntity, ModelData modelData, boolean modelNeedsRotationFix) {
        this(blockState, blockEntity, modelData, modelNeedsRotationFix, (Lazy<ItemStack>)Lazy.of(() -> BlockToItemHelper.getItemStack(blockState, blockEntity, (Player)Minecraft.getInstance().player)));
    }

    private BlockStateRenderingData(BlockState blockState, BlockEntity blockEntity, ModelData modelData) {
        this(blockState, blockEntity, modelData, BlockStateRenderingData.checkModelForYrotation(blockState));
    }

    public static BlockStateRenderingData of(Level level, BlockPos pos, Player player) {
        BlockState blockState = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        ItemStack itemStack = BlockToItemHelper.getItemStack(level, pos, player);
        return new BlockStateRenderingData(blockState, blockEntity, BlockStateRenderingData.getModelData(blockState, blockEntity), BlockStateRenderingData.checkModelForYrotation(blockState), (Lazy<ItemStack>)Lazy.of(() -> itemStack));
    }

    public static BlockStateRenderingData of(BlockState blockState, @Nullable BlockEntity blockEntity) {
        return blockEntity == null ? BlockStateRenderingData.of(blockState) : new BlockStateRenderingData(blockState, blockEntity, BlockStateRenderingData.getModelData(blockState, blockEntity));
    }

    public static BlockStateRenderingData of(BlockState blockState) {
        EntityBlock entityBlock;
        BlockEntity be;
        Block block;
        if (blockState.hasBlockEntity() && (block = blockState.getBlock()) instanceof EntityBlock && (be = (entityBlock = (EntityBlock)block).newBlockEntity(ILLEGAL_BLOCK_ENTITY_POS, blockState)) != null) {
            return BlockStateRenderingData.of(blockState, be);
        }
        return new BlockStateRenderingData(blockState, null, null);
    }

    public BlockStateRenderingData updateBlockEntity(Function<BlockEntity, BlockEntity> updater) {
        BlockEntity updated = updater.apply(this.blockEntity);
        return new BlockStateRenderingData(this.blockState, updated, BlockStateRenderingData.getModelData(this.blockState, updated), this.modelNeedsRotationFix);
    }

    public ModelData modelData() {
        return this.modelData == null ? ModelData.EMPTY : this.modelData;
    }

    private static ModelData getModelData(BlockState blockState, BlockEntity blockEntity) {
        ModelData model = ModelData.EMPTY;
        try {
            model = blockEntity.getModelData();
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not get model data for: " + blockState.toString(), (Throwable)e);
        }
        return model;
    }

    public ItemStack itemStack() {
        return (ItemStack)this.playerPickedItemStack.get();
    }

    public static boolean checkModelForYrotation(BlockState blockState) {
        BlockModel blockModel;
        ModelResourceLocation modelResLoc = BlockModelShaper.stateToModelLocation((BlockState)blockState);
        ModelBakery modelBakery = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getModelManager().getModelBakery();
        UnbakedModel model = (UnbakedModel)modelBakery.topLevelModels.get(modelResLoc);
        if (model instanceof BlockModel) {
            BlockModel bm = (BlockModel)model;
            v0 = bm;
        } else if (model instanceof MultiVariant) {
            MultiVariant mv = (MultiVariant)model;
            v0 = (BlockModel)modelBakery.modelResources.get(ModelBakery.MODEL_LISTER.idToFile(((Variant)mv.getVariants().get(0)).getModelLocation()));
        } else {
            v0 = blockModel = null;
        }
        if (blockModel == null || blockModel.getElements().isEmpty()) {
            return false;
        }
        int headCountOfRotated = 0;
        for (BlockElement element : blockModel.getElements()) {
            if (element.rotation == null || element.rotation.axis() != Direction.Axis.Y) break;
            ++headCountOfRotated;
        }
        if (headCountOfRotated == 0) {
            return false;
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AXIS)) {
            return blockState.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y;
        }
        if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
            return facing == Direction.UP || facing == Direction.DOWN;
        }
        return true;
    }
}

