/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.mod;

import com.ldtteam.blockui.AtlasManager;
import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.hooks.HookManager;
import com.ldtteam.blockui.hooks.HookRegistries;
import com.ldtteam.blockui.mod.BlockStateTestGui;
import com.ldtteam.blockui.mod.ScrollingListsGui;
import com.ldtteam.blockui.mod.container.ContainerHook;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.BOWindow;
import com.mojang.blaze3d.platform.InputConstants;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

public class ClientEventSubscriber {
    @SubscribeEvent
    public static void onClientTickStart(ClientTickEvent.Pre event) {
        if (Screen.hasAltDown() && Screen.hasControlDown() && Screen.hasShiftDown() && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)88)) {
            BOWindow window = new BOWindow();
            int id = 0;
            Button dumpAtlases = ClientEventSubscriber.createTestGuiButton(id++, "Dump mod atlases to run folder", null, new Consumer[0]);
            dumpAtlases.setHandler(b -> {
                Path dumpingFolder = Path.of("atlas_dump", new String[0]).toAbsolutePath().normalize();
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)("Dumping atlases into: " + dumpingFolder.toString())));
                AtlasManager.INSTANCE.dumpAtlases(dumpingFolder);
            });
            window.addChild(dumpAtlases);
            window.addChild(ClientEventSubscriber.createTestGuiButton(id++, "General All-in-one", ResourceLocation.fromNamespaceAndPath((String)"blockui", (String)"gui/test.xml"), parent -> {
                parent.findPaneOfTypeByID("missing_out_of_jar", Image.class).setImage(OutOfJarResourceLocation.ofMinecraftFolder("blockui", "missing_out_of_jar.png"), false);
                parent.findPaneOfTypeByID("working_out_of_jar", Image.class).setImage(OutOfJarResourceLocation.of("blockui", Path.of("../../src/test/resources/button.png", new String[0])), false);
            }));
            window.addChild(ClientEventSubscriber.createTestGuiButton(id++, "Tooltip Positioning", ResourceLocation.fromNamespaceAndPath((String)"blockui", (String)"gui/test2.xml"), new Consumer[0]));
            window.addChild(ClientEventSubscriber.createTestGuiButton(id++, "ItemIcon To BlockState", ResourceLocation.fromNamespaceAndPath((String)"blockui", (String)"gui/test3.xml"), BlockStateTestGui::setup));
            window.addChild(ClientEventSubscriber.createTestGuiButton(id++, "Scrolling Lists", ResourceLocation.fromNamespaceAndPath((String)"blockui", (String)"gui/test4.xml"), ScrollingListsGui::setup));
            Text builderTest = new Text();
            builderTest.setSize(420, 20);
            builderTest.setPosition(0, (id + 1) / 2 * (builderTest.getHeight() + 10));
            ((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)PaneBuilders.textBuilder().append(Component.literal((String)"blockui"))).append(Component.literal((String)" - "))).append(Component.literal((String)ModList.get().getModFileById("blockui").versionString()))).paragraphBreak()).colorName("red")).underlined()).append(Component.translatable((String)"blockui.tooltip.item_additional_info", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.control").append(" + ").append((Component)Component.translatable((String)"key.keyboard.left.shift")).append(" + ").append((Component)Component.translatable((String)"key.keyboard.left.alt")).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)))}))).applyToPane(builderTest);
            window.addChild(builderTest);
            window.open();
        }
    }

    @SubscribeEvent
    public static void onClientTickEnd(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().level != null) {
            Minecraft.getInstance().getProfiler().push("hook_manager_tick");
            HookRegistries.tick(Minecraft.getInstance().level.getGameTime());
            Minecraft.getInstance().getProfiler().pop();
        }
    }

    @SafeVarargs
    private static Button createTestGuiButton(int order, String name, ResourceLocation testGuiResLoc, final Consumer<BOWindow> ... setups) {
        ButtonImage button = new ButtonImage();
        button.setPosition(order % 2 * (button.getWidth() + 20), order / 2 * (button.getHeight() + 10));
        button.setText(Component.literal((String)name));
        button.setHandler(b -> new BOWindow(testGuiResLoc){

            @Override
            public void onOpened() {
                super.onOpened();
                for (Consumer setup : setups) {
                    setup.accept(this);
                }
            }
        }.openAsLayer());
        return button;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseScrollEvent(InputEvent.MouseScrollingEvent event) {
        event.setCanceled(HookManager.onScroll(event.getScrollDeltaX(), event.getScrollDeltaY()));
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ContainerHook.init();
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiLayerEvent.Pre event) {
        if (Minecraft.getInstance().screen instanceof BOScreen && event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            event.setCanceled(true);
        }
    }
}

