/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.bettervillage.mixin;

import com.jtorleonstudios.bettervillage.Config;
import com.jtorleonstudios.bettervillage.Main;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.List;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StructureSet.class}, priority=423697)
public abstract class StructureSetMixin {
    @Unique
    private boolean betterVillage$EnabledReplacement = false;

    @Inject(method={"<init>(Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/placement/StructurePlacement;)V"}, at={@At(value="RETURN")})
    public void onCreateStructureSet(List<StructureSet.StructureSelectionEntry> list, StructurePlacement b, CallbackInfo ci) {
        if (Config.get().getBoolOrDefault(Config.VILLAGE_ENABLE_CONFIG) && list.stream().anyMatch(entry -> entry.structure().unwrapKey().map(key -> Main.VILLAGE_WHITELIST_REPLACEMENT.contains(key.location().toString())).orElse(false))) {
            Main.LOGGER.info("StructureSet modified for minecraft:village : Now using custom village configuration (can be disabled in the better villages config: boolean.villages.enabled_custom_config).");
            this.betterVillage$EnabledReplacement = true;
        }
    }

    @ModifyReturnValue(method={"placement()Lnet/minecraft/world/level/levelgen/structure/placement/StructurePlacement;"}, at={@At(value="RETURN")})
    public StructurePlacement onGetPlacement(StructurePlacement placement) {
        if (this.betterVillage$EnabledReplacement) {
            return Main.STRUCTURE_CONFIG;
        }
        return placement;
    }
}

