/*
 * Decompiled with CFR 0.152.
 */
package betterdays.message;

import betterdays.config.ConfigHandler;
import betterdays.message.TemplateMessage;
import betterdays.time.SleepStatus;
import betterdays.time.TimeService;
import betterdays.time.TimeServiceManager;
import betterdays.wrappers.ServerLevelWrapper;
import betterdays.wrappers.ServerPlayerWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;

public class BetterDaysMessages {
    public static void onSleepingCheckEvent(Player player) {
        TimeService service = TimeServiceManager.service;
        if (ConfigHandler.Common.enableSleepFeature() && player.getSleepTimer() == 2 && player.getClass() == ServerPlayerWrapper.playerClass && service != null && ((ServerLevel)service.level.get()).equals(player.level()) && ((ServerLevel)service.level.get()).players().size() > 1 && service.level.daylightRuleEnabled()) {
            BetterDaysMessages.sendEnterBedMessage(new ServerPlayerWrapper(player));
        }
    }

    public static void onPlayerWakeUpEvent(Player player) {
        TimeService service = TimeServiceManager.service;
        if (ConfigHandler.Common.enableSleepFeature() && player.getClass() == ServerPlayerWrapper.playerClass && service != null && ((ServerLevel)service.level.get()).equals(player.level()) && ((ServerLevel)service.level.get()).players().size() > 1 && service.level.daylightRuleEnabled()) {
            BetterDaysMessages.sendLeaveBedMessage(new ServerPlayerWrapper(player));
        }
    }

    public static void onSleepFinishedEvent(LevelAccessor level) {
        TimeService service = TimeServiceManager.service;
        if (ConfigHandler.Common.enableSleepFeature() && service != null && ((ServerLevel)service.level.get()).equals(level) && service.level.daylightRuleEnabled()) {
            ServerLevelWrapper levelWrapper = new ServerLevelWrapper(level);
            BetterDaysMessages.sendMorningMessage(levelWrapper);
        }
    }

    public static void sendEnterBedMessage(ServerPlayerWrapper player) {
        String templateMessage = ConfigHandler.Common.enterBedMessage();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(ConfigHandler.Common.enterBedMessageType().isOverlay()).setVariable("player", ((ServerPlayer)player.get()).getGameProfile().getName()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.amountSleeping())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send(ConfigHandler.Common.enterBedMessageTarget(), player.getLevel());
    }

    public static void sendLeaveBedMessage(ServerPlayerWrapper player) {
        String templateMessage = ConfigHandler.Common.leaveBedMessage();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(ConfigHandler.Common.leaveBedMessageType().isOverlay()).setVariable("player", ((ServerPlayer)player.get()).getGameProfile().getName()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.amountSleeping() - 1)).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send(ConfigHandler.Common.leaveBedMessageTarget(), player.getLevel());
    }

    public static void sendMorningMessage(ServerLevelWrapper level) {
        String templateMessage = ConfigHandler.Common.morningMessage();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(ConfigHandler.Common.morningMessageType().isOverlay()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.amountSleeping())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send(ConfigHandler.Common.morningMessageTarget(), level);
    }
}

