/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.events;

import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import net.Pandarix.BACommon;
import net.Pandarix.config.BAConfig;
import net.Pandarix.enchantment.ModEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TunnelingEventHandler {
    public static EventResult handleTunneling(Level level, BlockPos blockPos, BlockState blockState, ServerPlayer serverPlayer, IntValue intValue) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverPlayer != null) {
                try {
                    ItemStack stack = serverPlayer.getMainHandItem();
                    Holder.Reference tunneling = level.registryAccess().asGetterLookup().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ModEnchantments.TUNNELING_KEY);
                    if (BAConfig.artifactsEnabled && BAConfig.tunnelingEnabled && !serverPlayer.isShiftKeyDown() && !stack.isEmpty() && stack.isEnchanted() && EnchantmentHelper.getItemEnchantmentLevel((Holder)tunneling, (ItemStack)stack) >= 1) {
                        boolean inHardnessTolerance;
                        BlockPos ba$downPos = blockPos.below();
                        BlockState ba$blockStateBelow = level.getBlockState(ba$downPos);
                        if (ba$blockStateBelow instanceof GameMasterBlock) {
                            return EventResult.pass();
                        }
                        boolean correctTool = BAConfig.tunnelingEffectiveTool ? stack.isCorrectToolForDrops(blockState) && stack.isCorrectToolForDrops(ba$blockStateBelow) : true;
                        boolean bl = inHardnessTolerance = (double)Math.abs(level.getBlockState(ba$downPos).getDestroySpeed((BlockGetter)level, ba$downPos) - level.getBlockState(blockPos).getDestroySpeed((BlockGetter)level, blockPos)) <= BAConfig.tunnelingTolerance;
                        if (correctTool && inHardnessTolerance) {
                            if (serverPlayer.blockActionRestricted((Level)serverLevel, ba$downPos, serverPlayer.gameMode.getGameModeForPlayer())) {
                                return null;
                            }
                            if (serverPlayer.isCreative()) {
                                TunnelingEventHandler.performBreak(serverLevel, ba$downPos, ba$blockStateBelow);
                            } else {
                                ItemStack copiedStack = stack.copy();
                                stack.hurtAndBreak(1, (LivingEntity)serverPlayer, serverPlayer.getEquipmentSlotForItem(stack));
                                boolean successfulBreak = TunnelingEventHandler.performBreak(serverLevel, ba$downPos, ba$blockStateBelow);
                                if (successfulBreak) {
                                    BlockEntity blockEntity = serverLevel.getBlockEntity(ba$downPos);
                                    ba$blockStateBelow.getBlock().playerDestroy((Level)serverLevel, (Player)serverPlayer, ba$downPos, ba$blockStateBelow, blockEntity, copiedStack);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    BACommon.LOGGER.error("Could not find Tunneling in the Enchantment Registries!", (Throwable)e);
                }
            }
        }
        return EventResult.pass();
    }

    private static boolean performBreak(ServerLevel serverLevel, BlockPos pos, BlockState blockState) {
        boolean removed = serverLevel.removeBlock(pos, false);
        if (removed) {
            blockState.getBlock().destroy((LevelAccessor)serverLevel, pos, blockState);
        }
        return removed;
    }
}

