/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.notoml;

import com.google.common.collect.Table;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.notoml.Notoml;
import net.minecraft.resources.ResourceLocation;

public class NotomlSerializer {
    public static void serialize(Writer writer, Notoml notoml) throws IOException {
        writer.write(NotomlSerializer.serializeToString(notoml));
    }

    private static String serializeToString(Notoml notoml) {
        StringBuilder sb = new StringBuilder();
        Table<String, String, Object> data = notoml.getProperties();
        Table<String, String, String> comments = notoml.getComments();
        List sortedCategoryKeys = data.rowKeySet().stream().sorted().toList();
        for (String category : sortedCategoryKeys) {
            String categoryComment = (String)comments.get((Object)category, (Object)"");
            if (categoryComment != null) {
                sb.append("\n").append("# ").append(categoryComment).append("\n");
            }
            if (!category.isEmpty()) {
                sb.append("[").append(category).append("]").append("\n");
            }
            Map categoryProperties = data.row((Object)category);
            List sortedPropertyKeys = categoryProperties.keySet().stream().sorted().toList();
            for (String property : sortedPropertyKeys) {
                String propertyComment = (String)comments.get((Object)category, (Object)property);
                if (propertyComment != null) {
                    sb.append("\n").append("# ").append(propertyComment).append("\n");
                }
                sb.append(property).append(" = ");
                Object value = categoryProperties.get(property);
                if (value instanceof String) {
                    String stringValue = (String)value;
                    if (stringValue.contains("\n")) {
                        sb.append("\"\"\"\n").append(value).append("\n\"\"\"");
                    } else {
                        sb.append("\"").append(stringValue.replace("\"", "\\\"")).append("\"");
                    }
                } else if (value instanceof ResourceLocation) {
                    ResourceLocation resourceLocationValue = (ResourceLocation)value;
                    sb.append("\"").append(resourceLocationValue).append("\"");
                } else if (value instanceof Collection) {
                    Collection listValue = (Collection)value;
                    NotomlSerializer.serializeList(listValue, sb);
                } else if (value instanceof Enum) {
                    Enum enumValue = (Enum)value;
                    sb.append("\"").append(enumValue.name()).append("\"");
                } else {
                    sb.append(value);
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String serializeList(Collection<?> list, StringBuilder sb) {
        sb.append("[ ");
        boolean newLines = list.size() > 3;
        boolean first = true;
        for (Object value : list) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (newLines) {
                sb.append("\n");
            }
            if (newLines) {
                sb.append("    ");
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                sb.append("\"").append(stringValue.replace("\"", "\\\"")).append("\"");
                continue;
            }
            if (value instanceof ResourceLocation) {
                ResourceLocation resourceLocationValue = (ResourceLocation)value;
                sb.append("\"").append(resourceLocationValue).append("\"");
                continue;
            }
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                sb.append("\"").append(enumValue.name()).append("\"");
                continue;
            }
            sb.append(value);
        }
        if (newLines) {
            sb.append("\n]");
        } else {
            sb.append(" ]");
        }
        return sb.toString();
    }
}

