/*
 * Decompiled with CFR 0.152.
 */
package artifacts.util;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ModCodecs {
    public static <T> StreamCodec<ByteBuf, TagKey<T>> tagKeyStreamCodec(ResourceKey<? extends Registry<T>> registry) {
        return ResourceLocation.STREAM_CODEC.map(id -> TagKey.create((ResourceKey)registry, (ResourceLocation)id), TagKey::location);
    }

    public static <T> Codec<T> xorAlternative(Codec<T> codec, Codec<T> alternative) {
        return new XorAlternativeCodec<T>(codec, alternative);
    }

    public static <T> Codec<T> lazyCodec(Supplier<Codec<T>> codec) {
        return new LazyCodec(codec);
    }

    public static <B, T> StreamCodec<B, T> lazyStreamCodec(Supplier<StreamCodec<B, T>> codec) {
        return new LazyStreamCodec(codec);
    }

    private record XorAlternativeCodec<T>(Codec<T> codec, Codec<T> alternative) implements Codec<T>
    {
        public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
            DataResult result = this.codec.decode(ops, input);
            if (result.error().isEmpty()) {
                return result;
            }
            return this.alternative.decode(ops, input);
        }

        public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
            DataResult result = this.codec.encode(input, ops, prefix);
            if (result.error().isEmpty()) {
                return result;
            }
            return this.alternative.encode(input, ops, prefix);
        }

        @Override
        public String toString() {
            return "Alternative[" + String.valueOf(this.codec) + ", " + String.valueOf(this.alternative) + "]";
        }
    }

    private record LazyCodec<V>(Supplier<Codec<V>> codec = Suppliers.memoize(codec::get)) implements Codec<V>
    {
        public <T1> DataResult<Pair<V, T1>> decode(DynamicOps<T1> ops, T1 input) {
            return this.codec.get().decode(ops, input);
        }

        public <T1> DataResult<T1> encode(V input, DynamicOps<T1> ops, T1 prefix) {
            return this.codec.get().encode(input, ops, prefix);
        }
    }

    private record LazyStreamCodec<B, V>(Supplier<StreamCodec<B, V>> codec = Suppliers.memoize(codec::get)) implements StreamCodec<B, V>
    {
        public V decode(B buffer) {
            return (V)this.codec.get().decode(buffer);
        }

        public void encode(B buffer, V value) {
            this.codec.get().encode(buffer, value);
        }
    }
}

