/*
 * Decompiled with CFR 0.152.
 */
package artifacts.registry;

import artifacts.platform.PlatformServices;
import artifacts.registry.RegistryHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;

public class ModAttributes {
    public static final List<RegistryHolder<Attribute, ?>> ATTRIBUTES = new ArrayList();
    public static final List<Holder<Attribute>> PLAYER_ATTRIBUTES = new ArrayList<Holder<Attribute>>();
    public static final List<Holder<Attribute>> GENERIC_ATTRIBUTES = new ArrayList<Holder<Attribute>>();
    public static final Holder<Attribute> ENTITY_EXPERIENCE = ModAttributes.addPlayerAttribute("entity_experience", 1.0, 0.0, 64.0);
    public static final Holder<Attribute> VILLAGER_REPUTATION = ModAttributes.addPlayerAttribute("villager_reputation", 0.0, 0.0, 1024.0);
    public static final Holder<Attribute> ATTACK_BURNING_DURATION = ModAttributes.addGenericAttribute("attack_burning_duration", 0.0, 0.0, 60.0);
    public static final Holder<Attribute> DRINKING_SPEED = ModAttributes.addGenericAttribute("drinking_speed", 1.0, 1.0, Double.MAX_VALUE);
    public static final Holder<Attribute> EATING_SPEED = ModAttributes.addGenericAttribute("eating_speed", 1.0, 1.0, Double.MAX_VALUE);
    public static final Holder<Attribute> FLATULENCE = ModAttributes.addGenericAttribute("flatulence", 0.0, 0.0, 1.0);
    public static final Holder<Attribute> INVINCIBILITY_TICKS = ModAttributes.addGenericAttribute("invincibility_ticks", 0.0, 0.0, 1200.0);
    public static final Holder<Attribute> MOUNT_SPEED = ModAttributes.addGenericAttribute("mount_speed", 1.0, 1.0, 1024.0);
    public static final Holder<Attribute> MOVEMENT_SPEED_ON_SNOW = ModAttributes.addGenericAttribute("movement_speed_on_snow", 1.0, 0.0, 1024.0);
    public static final Holder<Attribute> SLIP_RESISTANCE = ModAttributes.addGenericAttribute("slip_resistance", 0.0, 0.0, 1.0);
    public static final Holder<Attribute> SPRINTING_SPEED = ModAttributes.addGenericAttribute("sprinting_speed", 1.0, 1.0, 1024.0);
    public static final Holder<Attribute> SPRINTING_STEP_HEIGHT = ModAttributes.addGenericAttribute("sprinting_step_height", 0.0, 0.0, 10.0);
    public static final Holder<Attribute> SWIM_SPEED = PlatformServices.platformHelper.getSwimSpeedAttribute();

    public static Holder<Attribute> addPlayerAttribute(String name, double d, double min, double max) {
        String id = "player." + name;
        Holder<Attribute> attribute = ModAttributes.register(id, d, min, max);
        PLAYER_ATTRIBUTES.add(attribute);
        return attribute;
    }

    public static Holder<Attribute> addGenericAttribute(String name, double d, double min, double max) {
        String id = "generic." + name;
        Holder<Attribute> attribute = ModAttributes.register(id, d, min, max);
        GENERIC_ATTRIBUTES.add(attribute);
        return attribute;
    }

    public static Holder<Attribute> register(String name, double d, double min, double max) {
        return ModAttributes.register(name, () -> new RangedAttribute(name, d, min, max).setSyncable(true));
    }

    private static Holder<Attribute> register(String name, Supplier<? extends Attribute> supplier) {
        return PlatformServices.platformHelper.registerAttribute(name, supplier);
    }
}

