/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.integration.curios;

import artifacts.event.ArtifactEvents;
import artifacts.item.WearableArtifactItem;
import artifacts.neoforge.curio.WearableArtifactCurio;
import artifacts.registry.ModItems;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosIntegration {
    public static void setup(IEventBus modBus) {
        modBus.addListener(CuriosIntegration::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(CuriosIntegration::onCurioChanged);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        if (ModList.get().isLoaded("curios")) {
            ModItems.ITEMS.forEach(entry -> {
                Object patt0$temp = entry.get();
                if (patt0$temp instanceof WearableArtifactItem) {
                    WearableArtifactItem item = (WearableArtifactItem)((Object)((Object)patt0$temp));
                    CuriosApi.registerCurio((Item)item, (ICurioItem)new WearableArtifactCurio(item));
                }
            });
        }
    }

    private static void onCurioChanged(CurioChangeEvent event) {
        ArtifactEvents.onItemChanged(event.getEntity(), event.getFrom(), event.getTo());
    }

    public static Stream<ItemStack> findAllEquippedBy(LivingEntity entity, Predicate<ItemStack> predicate) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(inv -> inv.findCurios(predicate)).orElse(List.of()).stream().map(SlotResult::stack);
    }

    public static void iterateEquippedCurios(LivingEntity entity, Consumer<ItemStack> consumer) {
        Optional itemHandler = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (itemHandler.isPresent()) {
            for (ICurioStacksHandler stacksHandler : ((ICuriosItemHandler)itemHandler.get()).getCurios().values()) {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    ItemStack item = stacksHandler.getStacks().getStackInSlot(i);
                    if (item.isEmpty()) continue;
                    consumer.accept(item);
                }
            }
        }
    }

    public static <T> T reduceCurios(LivingEntity entity, T init, BiFunction<ItemStack, T, T> f) {
        Optional itemHandler = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (itemHandler.isPresent()) {
            for (ICurioStacksHandler stacksHandler : ((ICuriosItemHandler)itemHandler.get()).getCurios().values()) {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    ItemStack item = stacksHandler.getStacks().getStackInSlot(i);
                    if (item.isEmpty()) continue;
                    init = f.apply(item, (ItemStack)init);
                }
            }
        }
        return init;
    }

    public static boolean tryEquipInFirstSlot(LivingEntity entity, ItemStack item) {
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (optional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)optional.get();
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    SlotContext slotContext = new SlotContext((String)entry.getKey(), entity, i, false, true);
                    if (!CuriosApi.isStackValid((SlotContext)slotContext, (ItemStack)item) || !((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i).isEmpty()) continue;
                    ((ICurioStacksHandler)entry.getValue()).getStacks().setStackInSlot(i, item);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isVisibleOnHand(LivingEntity entity, InteractionHand hand, Item item) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> Optional.ofNullable((ICurioStacksHandler)handler.getCurios().get("hands"))).map(stacksHandler -> {
            int startSlot;
            for (int slot = startSlot = hand == InteractionHand.MAIN_HAND ? 0 : 1; slot < stacksHandler.getSlots(); slot += 2) {
                ItemStack stack = stacksHandler.getCosmeticStacks().getStackInSlot(slot);
                if (stack.isEmpty() && ((Boolean)stacksHandler.getRenders().get(slot)).booleanValue()) {
                    stack = stacksHandler.getStacks().getStackInSlot(slot);
                }
                if (stack.getItem() != item) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }
}

