/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.event;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.UpgradeToolTierAbility;
import artifacts.component.AbilityToggles;
import artifacts.event.ArtifactEvents;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModTags;
import artifacts.util.AbilityHelper;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArtifactEventsNeoForge {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, ArtifactEventsNeoForge::onLivingDamage);
        NeoForge.EVENT_BUS.addListener(ArtifactEventsNeoForge::onLivingUpdate);
        NeoForge.EVENT_BUS.addListener(ArtifactEventsNeoForge::onDrinkingHatItemUse);
        NeoForge.EVENT_BUS.addListener(ArtifactEventsNeoForge::onGoldenHookExperienceDrop);
        NeoForge.EVENT_BUS.addListener(ArtifactEventsNeoForge::onKittySlippersChangeTarget);
        NeoForge.EVENT_BUS.addListener(ArtifactEventsNeoForge::onDiggingClawsHarvestCheck);
        NeoForge.EVENT_BUS.addListener(ArtifactEventsNeoForge::onPlayerTick);
        NeoForge.EVENT_BUS.addListener(ArtifactEventsNeoForge::onBlockDrops);
    }

    private static void onPlayerTick(PlayerTickEvent.Post event) {
        AbilityToggles abilityToggles = PlatformServices.platformHelper.getAbilityToggles((LivingEntity)event.getEntity());
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (abilityToggles != null) {
                abilityToggles.sendToClient(serverPlayer);
            }
        }
    }

    private static void onLivingDamage(LivingDamageEvent.Post event) {
        ArtifactEvents.onLivingDamaged(event.getEntity(), event.getSource(), event.getNewDamage());
    }

    private static void onLivingUpdate(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            ArtifactEventsNeoForge.onKittySlippersLivingUpdate(entity2);
            ArtifactEvents.livingUpdate(entity2);
        }
    }

    private static void onDrinkingHatItemUse(LivingEntityUseItemEvent.Start event) {
        event.setDuration(ArtifactEvents.modifyUseDuration(event.getDuration(), event.getItem(), event.getEntity()));
    }

    private static void onGoldenHookExperienceDrop(LivingExperienceDropEvent event) {
        int droppedXp = event.getDroppedExperience();
        int modifiedXp = ArtifactEvents.modifyExperience(droppedXp, event.getEntity(), event.getAttackingPlayer());
        event.setDroppedExperience(modifiedXp);
    }

    private static void onKittySlippersChangeTarget(LivingChangeTargetEvent event) {
        Mob creeper;
        LivingEntity livingEntity;
        LivingEntity target = event.getNewAboutToBeSetTarget();
        if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SCARE_CREEPERS.value(), target) && (livingEntity = event.getEntity()) instanceof Mob && (creeper = (Mob)livingEntity).getType().is(ModTags.CREEPERS)) {
            event.setCanceled(true);
        }
    }

    private static void onKittySlippersLivingUpdate(LivingEntity entity) {
        if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SCARE_CREEPERS.value(), entity.getLastHurtByMob()) && entity.getType().is(ModTags.CREEPERS)) {
            entity.setLastHurtByMob(null);
        }
    }

    private static void onDiggingClawsHarvestCheck(PlayerEvent.HarvestCheck event) {
        event.setCanHarvest(event.canHarvest() || UpgradeToolTierAbility.canHarvestWithTier((LivingEntity)event.getEntity(), event.getTargetBlock()));
    }

    private static void onBlockDrops(BlockDropsEvent event) {
        List drops = event.getDrops();
        MutableInt experience = new MutableInt(0);
        drops.forEach(itemEntity -> itemEntity.setItem(ArtifactEvents.applySmeltOresAbility(itemEntity.getItem(), event.getBreaker(), event.getState(), arg_0 -> ((MutableInt)experience).add(arg_0))));
        event.setDroppedExperience(event.getDroppedExperience() + experience.getValue());
    }
}

