/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item;

import artifacts.Artifacts;
import artifacts.ability.ArtifactAbility;
import artifacts.ability.AttributeModifierAbility;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModDataComponents;
import artifacts.util.AbilityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")})
    private void getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> cir, List<Component> tooltipList) {
        ArrayList<MutableComponent> tooltip;
        if (!Artifacts.CONFIG.client.showTooltips.get().booleanValue()) {
            return;
        }
        ItemStack stack = (ItemStack)this;
        if (stack.getItem() instanceof WearableArtifactItem) {
            tooltip = new ArrayList<MutableComponent>();
            if (AbilityHelper.isCosmetic(stack)) {
                tooltip.add(Component.translatable((String)"%s.tooltip.cosmetic".formatted("artifacts")).withStyle(ChatFormatting.ITALIC));
            } else {
                PlatformServices.platformHelper.addCosmeticToggleTooltip(tooltip, stack);
            }
            tooltip.forEach(line -> tooltipList.add((Component)line.withStyle(ChatFormatting.GRAY)));
        }
        if (stack.has((DataComponentType)ModDataComponents.ABILITIES.value())) {
            tooltip = new ArrayList();
            if (!AbilityHelper.isCosmetic(stack)) {
                for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
                    ability.addTooltipIfNonCosmetic(tooltip);
                }
            }
            tooltip.forEach(line -> tooltipList.add((Component)line.withStyle(ChatFormatting.GRAY)));
        }
    }

    @Inject(method={"addAttributeTooltips(Ljava/util/function/Consumer;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="TAIL")})
    private void addAttributeTooltips(Consumer<Component> consumer, @Nullable Player player, CallbackInfo info) {
        ItemStack self = (ItemStack)this;
        ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)self.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        boolean hasSlotTooltip = false;
        if (itemAttributeModifiers.showInTooltip()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                MutableBoolean b = new MutableBoolean(false);
                self.forEachModifier(slot, (holder, attributeModifier) -> b.setTrue());
                if (!b.booleanValue()) continue;
                hasSlotTooltip = true;
                ItemStackMixin.artifacts$addAbilityAttributeTooltips(self, consumer);
            }
        }
        if (!hasSlotTooltip) {
            if (AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.ATTRIBUTE_MODIFIER.value(), self) || AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.MOB_EFFECT.value(), self) || AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.LIMITED_WATER_BREATHING.value(), self)) {
                consumer.accept(CommonComponents.EMPTY);
                consumer.accept((Component)Component.translatable((String)"item.modifiers.body").withStyle(ChatFormatting.GRAY));
            }
            ItemStackMixin.artifacts$addAbilityAttributeTooltips(self, consumer);
        }
        ItemStackMixin.artifacts$addWhenHurtTooltips(consumer, self);
        ItemStackMixin.artifacts$addPerFoodPointEatenTooltip(consumer, self);
        ItemStackMixin.artifacts$addAttacksInflictTooltip(consumer, self, false);
        ItemStackMixin.artifacts$addAttacksInflictTooltip(consumer, self, true);
    }

    @Unique
    private static void artifacts$addAbilityAttributeTooltips(ItemStack stack, Consumer<Component> tooltip) {
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.ATTRIBUTE_MODIFIER.value(), stack).forEach(ability -> ItemStackMixin.artifacts$addAbilityAttributeTooltip(tooltip, ability));
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.MOB_EFFECT.value(), stack).forEach(ability -> ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (MobEffect)ability.mobEffect().value(), (Integer)ability.duration().get(), (Integer)ability.level().get(), ability.isInfinite()));
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.LIMITED_WATER_BREATHING.value(), stack).forEach(ability -> ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (MobEffect)ability.mobEffect().value(), (Integer)ability.duration().get(), (Integer)ability.level().get(), ability.isInfinite()));
    }

    @Unique
    private static void artifacts$addAbilityAttributeTooltip(Consumer<Component> tooltip, AttributeModifierAbility ability) {
        double amount = (Double)ability.amount().get();
        if (ability.operation() != AttributeModifier.Operation.ADD_VALUE) {
            amount *= 100.0;
        } else if (ability.attribute().equals((Object)Attributes.KNOCKBACK_RESISTANCE)) {
            amount *= 10.0;
        }
        if (amount > 0.0) {
            tooltip.accept((Component)Component.translatable((String)("attribute.modifier.plus." + ability.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(amount), Component.translatable((String)((Attribute)ability.attribute().value()).getDescriptionId())}).withStyle(((Attribute)ability.attribute().value()).getStyle(true)));
        } else if (amount < 0.0) {
            tooltip.accept((Component)Component.translatable((String)("attribute.modifier.take." + ability.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(amount *= -1.0), Component.translatable((String)((Attribute)ability.attribute().value()).getDescriptionId())}).withStyle(((Attribute)ability.attribute().value()).getStyle(false)));
        }
    }

    @Unique
    private static void artifacts$addWhenHurtTooltips(Consumer<Component> tooltip, ItemStack stack) {
        MutableBoolean flag = new MutableBoolean(false);
        ArrayList list = new ArrayList();
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_DAMAGE.value(), stack).forEach(ability -> {
            if (ability.tag().isEmpty()) {
                flag.setTrue();
            } else if (!list.contains(ability.tag().get())) {
                list.add(ability.tag().get());
            }
        });
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_COOLDOWN_AFTER_DAMAGE.value(), stack).forEach(ability -> {
            if (ability.tag().isEmpty()) {
                flag.setTrue();
            } else if (!list.contains(ability.tag().get())) {
                list.add(ability.tag().get());
            }
        });
        if (flag.booleanValue()) {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.when_hurt").withStyle(ChatFormatting.GRAY));
            ItemStackMixin.artifacts$addWhenHurtTooltip(tooltip, stack, null);
        }
        for (TagKey tag : list) {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.when_hurt.%s".formatted(tag.location().toString().replace("minecraft:", "").replace(':', '.'))).withStyle(ChatFormatting.GRAY));
            ItemStackMixin.artifacts$addWhenHurtTooltip(tooltip, stack, (TagKey<DamageType>)tag);
        }
    }

    @Unique
    private static void artifacts$addWhenHurtTooltip(Consumer<Component> tooltip, ItemStack stack, @Nullable TagKey<DamageType> tag) {
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_DAMAGE.value(), stack).forEach(ability -> {
            if (ability.tag().isEmpty() && tag == null || ability.tag().isPresent() && ability.tag().get().equals((Object)tag)) {
                ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (MobEffect)ability.mobEffect().value(), (Integer)ability.duration().get(), (Integer)ability.level().get(), false);
            }
        });
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_COOLDOWN_AFTER_DAMAGE.value(), stack).forEach(ability -> {
            if (ability.tag().isEmpty() && tag == null || ability.tag().isPresent() && ability.tag().get().equals((Object)tag)) {
                tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{ItemStackMixin.artifacts$formatDurationSeconds((Integer)ability.cooldown().get())}).withStyle(ChatFormatting.GOLD));
            }
        });
    }

    @Unique
    private static void artifacts$addPerFoodPointEatenTooltip(Consumer<Component> tooltip, ItemStack stack) {
        if (AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_EATING.value(), stack)) {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.per_food_point_restored").withStyle(ChatFormatting.GRAY));
            AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_EATING.value(), stack).forEach(ability -> ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (MobEffect)ability.mobEffect().value(), (Integer)ability.duration().get(), (Integer)ability.level().get(), false));
        }
    }

    @Unique
    private static void artifacts$addAttacksInflictTooltip(Consumer<Component> tooltip, ItemStack stack, boolean chance) {
        if (AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.value(), stack, ability -> chance ^ Mth.equal((double)((Double)ability.chance().get()), (double)1.0))) {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)("artifacts.tooltip.attacks_inflict." + (chance ? "chance" : "constant"))).withStyle(ChatFormatting.GRAY));
            AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.value(), stack).forEach(ability -> {
                ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (MobEffect)ability.mobEffect().value(), (Integer)ability.duration().get(), (Integer)ability.level().get(), false);
                if ((Integer)ability.cooldown().get() > 0) {
                    tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{ItemStackMixin.artifacts$formatDurationSeconds((Integer)ability.cooldown().get())}).withStyle(ChatFormatting.GOLD));
                }
            });
        }
    }

    @Unique
    private static void artifacts$addMobEffectTooltip(Consumer<Component> tooltip, MobEffect mobEffect, int duration, int level, boolean isInfinite) {
        MutableComponent mutableComponent = Component.translatable((String)mobEffect.getDescriptionId());
        if (level > 1) {
            mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + (level - 1)))});
        }
        if (!isInfinite) {
            mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, ItemStackMixin.artifacts$formatDurationSeconds(duration)});
        }
        tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.plus_mob_effect", (Object[])new Object[]{mutableComponent}).withStyle(mobEffect.getCategory().getTooltipFormatting()));
    }

    @Unique
    private static MutableComponent artifacts$formatDurationSeconds(int seconds) {
        return Component.literal((String)StringUtil.formatTickDuration((int)(seconds * 20), (float)20.0f));
    }
}

