/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.Artifacts;
import artifacts.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;

public abstract class ArtifactItem
extends Item {
    public ArtifactItem(Item.Properties properties) {
        super(properties.arch$tab(ModItems.CREATIVE_TAB).stacksTo(1).rarity(Rarity.RARE).fireResistant());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        if (Artifacts.CONFIG.client.showTooltips.get().booleanValue()) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            this.addTooltip(tooltip);
            tooltip.forEach(line -> tooltipList.add((Component)line.withStyle(ChatFormatting.GRAY)));
        }
    }

    protected void addTooltip(List<MutableComponent> tooltip) {
        if (this.isCosmetic()) {
            tooltip.add(Component.translatable((String)"%s.tooltip.cosmetic".formatted("artifacts")).withStyle(ChatFormatting.ITALIC));
        } else {
            this.addEffectsTooltip(tooltip);
        }
    }

    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        tooltip.add(Component.translatable((String)"%s.tooltip.item.%s".formatted("artifacts", this.getTooltipItemName())));
    }

    protected MutableComponent tooltipLine(String lineId, Object ... args) {
        return Component.translatable((String)"%s.tooltip.item.%s.%s".formatted("artifacts", this.getTooltipItemName(), lineId), (Object[])args);
    }

    protected String getTooltipItemName() {
        return BuiltInRegistries.ITEM.getKey((Object)this).getPath();
    }

    public abstract boolean isCosmetic();
}

