/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.CollideWithFluidsAbility;
import artifacts.component.SwimData;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import be.florens.expandability.api.EventResult;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FluidState;

public class SwimEvents {
    public static void register() {
        TickEvent.PLAYER_PRE.register(SwimEvents::onPlayerTick);
    }

    private static void onPlayerTick(Player player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData != null) {
            if (player.isInWater() || player.isInLava() || player.fallDistance > 6.0f) {
                if (!swimData.isWet()) {
                    swimData.setWet(true);
                }
            } else if (player.onGround() || player.getAbilities().flying) {
                swimData.setWet(false);
            }
        }
    }

    public static EventResult onPlayerSwim(Player player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData != null) {
            if (swimData.isSwimming()) {
                return EventResult.SUCCESS;
            }
            if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SINKING.value(), (LivingEntity)player)) {
                return EventResult.FAIL;
            }
        }
        return EventResult.PASS;
    }

    public static boolean onFluidCollision(LivingEntity player, FluidState fluidState) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData(player);
        if (swimData == null || swimData.isWet() || swimData.isSwimming()) {
            return false;
        }
        if (SwimEvents.canSprintOnFluid(player, fluidState) || SwimEvents.canSneakOnFluid(player, fluidState)) {
            SwimEvents.dealLavaDamage(player, fluidState);
            return true;
        }
        return false;
    }

    private static boolean canSprintOnFluid(LivingEntity entity, FluidState fluidState) {
        return SwimEvents.canCollideWithFluid(entity, fluidState, (ArtifactAbility.Type)ModAbilities.SPRINT_ON_FLUIDS.value()) && entity.isSprinting() && !entity.isUsingItem() && !entity.isCrouching();
    }

    private static boolean canSneakOnFluid(LivingEntity entity, FluidState fluidState) {
        return entity.isCrouching() && SwimEvents.canCollideWithFluid(entity, fluidState, (ArtifactAbility.Type)ModAbilities.SNEAK_ON_FLUIDS.value());
    }

    private static boolean canCollideWithFluid(LivingEntity entity, FluidState fluidState, ArtifactAbility.Type<CollideWithFluidsAbility> type) {
        return AbilityHelper.hasAbilityActive(type, entity, ability -> ability.tag().isEmpty() || fluidState.is(ability.tag().get()));
    }

    private static void dealLavaDamage(LivingEntity entity, FluidState fluidState) {
        if (fluidState.is(FluidTags.LAVA) && !entity.fireImmune()) {
            entity.hurt(entity.damageSources().hotFloor(), 1.0f);
        }
    }
}

