/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.mimic;

import artifacts.Artifacts;
import artifacts.client.mimic.model.MimicChestLayerModel;
import artifacts.client.mimic.model.MimicModel;
import artifacts.entity.MimicEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MimicChestLayer
extends RenderLayer<MimicEntity, MimicModel> {
    public static final List<String> QUARK_CHEST_MATERIALS = Arrays.asList("oak", "spruce", "birch", "cherry", "jungle", "acacia", "dark_oak", "warped", "crimson", "azalea", "blossom", "mangrove", "bamboo");
    private final MimicChestLayerModel chestModel;
    public final Material vanillaChestMaterial;
    public final List<Material> chestMaterials;

    public MimicChestLayer(RenderLayerParent<MimicEntity, MimicModel> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        this.chestModel = new MimicChestLayerModel(modelSet.bakeLayer(MimicChestLayerModel.LAYER_LOCATION));
        this.chestMaterials = new ArrayList<Material>();
        boolean isChristmas = MimicChestLayer.isChristmas();
        Material material = this.vanillaChestMaterial = isChristmas ? Sheets.CHEST_XMAS_LOCATION : Sheets.CHEST_LOCATION;
        if (isChristmas) {
            this.chestMaterials.add(this.vanillaChestMaterial);
            return;
        }
        Material defaultMaterial = this.vanillaChestMaterial;
        if (Platform.isModLoaded((String)"lootr")) {
            defaultMaterial = MimicChestLayer.createMaterial("lootr", "chest");
        } else if (Platform.isModLoaded((String)"myloot")) {
            defaultMaterial = MimicChestLayer.createMaterial("myloot", "entity/chest/loot");
        }
        this.chestMaterials.add(defaultMaterial);
        MimicChestLayer.addQuarkMaterials(this.chestMaterials);
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 26 || calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    private static void addQuarkMaterials(List<Material> chestMaterials) {
        if (Platform.isModLoaded((String)"quark")) {
            String chestVariant = Platform.isModLoaded((String)"lootr") ? "lootr_normal" : "normal";
            for (String chestMaterial : QUARK_CHEST_MATERIALS) {
                chestMaterials.add(MimicChestLayer.createMaterial("quark", String.format("quark_variant_chests/%s/%s", chestMaterial, chestVariant)));
            }
        }
    }

    private static Material createMaterial(String modId, String location) {
        ResourceLocation chestAtlas = ResourceLocation.parse((String)"textures/atlas/chest.png");
        return new Material(chestAtlas, ResourceLocation.fromNamespaceAndPath((String)modId, (String)location));
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!mimic.isInvisible()) {
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStack.translate(-0.5, -1.5, -0.5);
            ((MimicModel)this.getParentModel()).copyPropertiesTo(this.chestModel);
            this.chestModel.prepareMobModel(mimic, limbSwing, limbSwingAmount, partialTicks);
            this.chestModel.setupAnim(mimic, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer builder = this.getChestMaterial(mimic).buffer(buffer, RenderType::entityCutout);
            this.chestModel.renderToBuffer(matrixStack, builder, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)mimic, (float)0.0f), -1);
            matrixStack.popPose();
        }
    }

    private Material getChestMaterial(MimicEntity mimic) {
        if (!Artifacts.CONFIG.client.useModdedMimicTextures.get().booleanValue()) {
            return this.vanillaChestMaterial;
        }
        if (this.chestMaterials.size() == 1) {
            return this.chestMaterials.getFirst();
        }
        return this.chestMaterials.get((int)(Math.abs(mimic.getUUID().getMostSignificantBits()) % (long)this.chestMaterials.size()));
    }
}

