/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.ConstantMobEffectAbility;
import artifacts.ability.mobeffect.MobEffectAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public class PermanentMobEffectAbility
extends ConstantMobEffectAbility {
    private static final Set<Holder<MobEffect>> CUSTOM_TOOLTIP_MOB_EFFECTS = Set.of(MobEffects.INVISIBILITY);
    public static final MapCodec<PermanentMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> MobEffectAbility.codecStart(instance).and((App)ValueTypes.enabledField().forGetter(ability -> ability.enabled)).apply((Applicative)instance, PermanentMobEffectAbility::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PermanentMobEffectAbility> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), ConstantMobEffectAbility::mobEffect, ValueTypes.MOB_EFFECT_LEVEL.streamCodec(), PermanentMobEffectAbility::level, ValueTypes.BOOLEAN.streamCodec(), ability -> ability.enabled, PermanentMobEffectAbility::new);
    private final Value<Boolean> enabled;

    public PermanentMobEffectAbility(Holder<MobEffect> mobEffect, Value<Integer> level, Value<Boolean> enabled) {
        super(mobEffect, level);
        this.enabled = enabled;
    }

    @Override
    public Value<Integer> level() {
        return (Boolean)this.enabled.get() != false ? super.level() : Value.of(0);
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.MOB_EFFECT.value();
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        for (Holder<MobEffect> mobEffect : CUSTOM_TOOLTIP_MOB_EFFECTS) {
            if (!mobEffect.isBound() || mobEffect.value() != this.mobEffect().value()) continue;
            tooltip.add(this.tooltipLine(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)mobEffect.value())).getPath(), new Object[0]));
            return;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PermanentMobEffectAbility that = (PermanentMobEffectAbility)o;
        return this.enabled.equals(that.enabled);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isEnabled());
    }
}

