/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.ConstantMobEffectAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public class NightVisionAbility
extends ConstantMobEffectAbility {
    public static final MapCodec<NightVisionAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.FRACTION.codec().optionalFieldOf("strength", Value.of(1.0)).forGetter(NightVisionAbility::strength)).apply((Applicative)instance, NightVisionAbility::new));
    public static final StreamCodec<ByteBuf, NightVisionAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), NightVisionAbility::strength, NightVisionAbility::new);
    private final Value<Double> strength;

    public NightVisionAbility(Value<Double> strength) {
        super((Holder<MobEffect>)MobEffects.NIGHT_VISION);
        this.strength = strength;
    }

    public Value<Double> strength() {
        return this.strength;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.NIGHT_VISION.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return !Mth.equal((double)((Double)this.strength().get()), (double)0.0);
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        if ((Double)this.strength.get() > 0.5) {
            tooltip.add(this.tooltipLine("full", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("partial", new Object[0]));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NightVisionAbility that = (NightVisionAbility)o;
        return this.strength.equals(that.strength);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.strength);
    }
}

