/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.ConstantMobEffectAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;

public class LimitedWaterBreathingAbility
extends ConstantMobEffectAbility {
    public static final MapCodec<LimitedWaterBreathingAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(LimitedWaterBreathingAbility::duration), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("infinite", Value.of(false)).forGetter(ability -> ability.isInfinite)).apply((Applicative)instance, LimitedWaterBreathingAbility::new));
    public static final StreamCodec<ByteBuf, LimitedWaterBreathingAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.DURATION.streamCodec(), LimitedWaterBreathingAbility::duration, ValueTypes.BOOLEAN.streamCodec(), ability -> ability.isInfinite, LimitedWaterBreathingAbility::new);
    private final Value<Integer> duration;
    private final Value<Boolean> isInfinite;

    public LimitedWaterBreathingAbility(Value<Integer> duration, Value<Boolean> isInfinite) {
        super((Holder<MobEffect>)MobEffects.WATER_BREATHING);
        this.duration = duration;
        this.isInfinite = isInfinite;
    }

    @Override
    public boolean isInfinite() {
        return (Boolean)this.isInfinite.get();
    }

    @Override
    public Value<Integer> duration() {
        return this.duration;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.LIMITED_WATER_BREATHING.value();
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        if (this.isInfinite()) {
            tooltip.add(this.tooltipLine("infinite", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("limited", new Object[0]));
        }
    }

    @Override
    protected int getAdditionalDuration(LivingEntity target) {
        if (!this.isInfinite() && target instanceof Player && target.getItemBySlot(EquipmentSlot.HEAD).is(Items.TURTLE_HELMET) && !target.isEyeInFluid(FluidTags.WATER)) {
            return 200;
        }
        return 0;
    }

    @Override
    public boolean shouldShowIcon() {
        return !this.isInfinite();
    }

    @Override
    public boolean shouldApplyMobEffect(LivingEntity entity) {
        return this.isInfinite() || !entity.isEyeInFluid(FluidTags.WATER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitedWaterBreathingAbility that = (LimitedWaterBreathingAbility)o;
        return this.duration.equals(that.duration) && this.isInfinite.equals(that.isInfinite);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.duration, this.isInfinite);
    }
}

