/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public record RemoveBadEffectsAbility(Value<Boolean> enabled, Value<Integer> maxEffectDuration) implements ArtifactAbility
{
    public static final MapCodec<RemoveBadEffectsAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.enabledField().forGetter(RemoveBadEffectsAbility::enabled), (App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(RemoveBadEffectsAbility::maxEffectDuration)).apply((Applicative)instance, RemoveBadEffectsAbility::new));
    public static final StreamCodec<ByteBuf, RemoveBadEffectsAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), RemoveBadEffectsAbility::enabled, ValueTypes.DURATION.streamCodec(), RemoveBadEffectsAbility::maxEffectDuration, RemoveBadEffectsAbility::new);

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.REMOVE_BAD_EFFECTS.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    @Override
    public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isActive) {
        if (!isActive) {
            return;
        }
        HashMap<Holder, MobEffectInstance> effects = new HashMap<Holder, MobEffectInstance>();
        int maxEffectDuration = (Integer)this.maxEffectDuration().get() * 20;
        entity.getActiveEffectsMap().forEach((effect, instance) -> {
            if (ModTags.isInTag((MobEffect)effect.value(), ModTags.ANTIDOTE_VESSEL_CANCELLABLE) && instance.getDuration() > maxEffectDuration) {
                effects.put((Holder)effect, (MobEffectInstance)instance);
            }
        });
        effects.forEach((effect, instance) -> {
            entity.removeEffectNoUpdate(effect);
            if (maxEffectDuration > 0) {
                entity.addEffect(new MobEffectInstance(effect, maxEffectDuration, instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon()));
            }
        });
    }
}

