/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModAttributes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public record AttributeModifierAbility(Holder<Attribute> attribute, Value<Double> amount, AttributeModifier.Operation operation, ResourceLocation id, boolean ignoreCooldown) implements ArtifactAbility
{
    private static final Set<Holder<Attribute>> POSITIVE_ATTRIBUTES_WITH_TOOLTIP;
    private static final Set<Holder<Attribute>> NEGATIVE_ATTRIBUTES_WITH_TOOLTIP;
    public static final MapCodec<AttributeModifierAbility> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, AttributeModifierAbility> STREAM_CODEC;

    public AttributeModifier createModifier() {
        return new AttributeModifier(this.id(), ((Double)this.amount().get()).doubleValue(), this.operation());
    }

    private void onAttributeUpdated(LivingEntity entity) {
        if (this.attribute() == Attributes.MAX_HEALTH && entity.getHealth() > entity.getMaxHealth()) {
            entity.setHealth(entity.getMaxHealth());
        }
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.ATTRIBUTE_MODIFIER.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return !Mth.equal((double)((Double)this.amount().get()), (double)0.0);
    }

    @Override
    public void onUnequip(LivingEntity entity, boolean wasActive) {
        AttributeInstance attributeInstance = entity.getAttribute(this.attribute());
        if (attributeInstance != null && wasActive) {
            attributeInstance.removeModifier(this.id());
            this.onAttributeUpdated(entity);
        }
    }

    @Override
    public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isActive) {
        AttributeInstance attributeInstance = entity.getAttribute(this.attribute());
        if (attributeInstance == null) {
            return;
        }
        AttributeModifier existingModifier = attributeInstance.getModifier(this.id());
        if (!this.ignoreCooldown() && isOnCooldown) {
            if (isActive) {
                this.onUnequip(entity, true);
            }
        } else if (existingModifier == null || !Mth.equal((double)((Double)this.amount().get()), (double)existingModifier.amount())) {
            attributeInstance.removeModifier(this.id());
            attributeInstance.addPermanentModifier(this.createModifier());
            this.onAttributeUpdated(entity);
        }
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        String attributeName = ((ResourceKey)this.attribute().unwrapKey().orElseThrow()).location().getPath();
        if (attributeName.equals("swim_speed")) {
            attributeName = "generic.swim_speed";
        }
        if ((Double)this.amount().get() > 0.0) {
            for (Holder<Attribute> attribute : POSITIVE_ATTRIBUTES_WITH_TOOLTIP) {
                if (!attribute.isBound() || attribute.value() != this.attribute().value()) continue;
                tooltip.add(this.tooltipLine(attributeName, new Object[0]));
            }
        } else {
            for (Holder<Attribute> attribute : NEGATIVE_ATTRIBUTES_WITH_TOOLTIP) {
                if (!attribute.isBound() || attribute.value() != this.attribute().value()) continue;
                tooltip.add(this.tooltipLine(attributeName, new Object[0]));
            }
        }
    }

    static {
        NEGATIVE_ATTRIBUTES_WITH_TOOLTIP = Set.of(Attributes.SCALE, Attributes.FALL_DAMAGE_MULTIPLIER);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP = new HashSet<Holder<Attribute>>();
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.addAll(ModAttributes.PLAYER_ATTRIBUTES);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.addAll(ModAttributes.GENERIC_ATTRIBUTES);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.add(ModAttributes.SWIM_SPEED);
        POSITIVE_ATTRIBUTES_WITH_TOOLTIP.addAll(List.of(Attributes.ATTACK_DAMAGE, Attributes.ATTACK_KNOCKBACK, Attributes.ATTACK_SPEED, Attributes.BLOCK_BREAK_SPEED, Attributes.JUMP_STRENGTH, Attributes.KNOCKBACK_RESISTANCE, Attributes.MAX_HEALTH, Attributes.SAFE_FALL_DISTANCE));
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(AttributeModifierAbility::attribute), (App)ValueTypes.ATTRIBUTE_MODIFIER_AMOUNT.codec().fieldOf("amount").forGetter(AttributeModifierAbility::amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(AttributeModifierAbility::operation), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(AttributeModifierAbility::id), (App)Codec.BOOL.optionalFieldOf("ignore_cooldown", (Object)true).forGetter(AttributeModifierAbility::ignoreCooldown)).apply((Applicative)instance, AttributeModifierAbility::new));
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ATTRIBUTE), AttributeModifierAbility::attribute, ValueTypes.ATTRIBUTE_MODIFIER_AMOUNT.streamCodec(), AttributeModifierAbility::amount, (StreamCodec)AttributeModifier.Operation.STREAM_CODEC, AttributeModifierAbility::operation, (StreamCodec)ResourceLocation.STREAM_CODEC, AttributeModifierAbility::id, (StreamCodec)ByteBufCodecs.BOOL, AttributeModifierAbility::ignoreCooldown, AttributeModifierAbility::new);
    }
}

