/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record AttractItemsAbility(Value<Boolean> enabled) implements ArtifactAbility
{
    public static final MapCodec<AttractItemsAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.enabledField().forGetter(AttractItemsAbility::enabled)).apply((Applicative)instance, AttractItemsAbility::new));
    public static final StreamCodec<ByteBuf, AttractItemsAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), AttractItemsAbility::enabled, AttractItemsAbility::new);

    public static EventResult onItemToss(Player player, ItemEntity entity) {
        if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.ATTRACT_ITEMS.value(), (LivingEntity)player, true)) {
            AbilityHelper.addCooldown((ArtifactAbility.Type)ModAbilities.ATTRACT_ITEMS.value(), (LivingEntity)player, 100);
        }
        return EventResult.pass();
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.ATTRACT_ITEMS.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    @Override
    public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isActive) {
        if (!isActive || isOnCooldown) {
            return;
        }
        Vec3 pos = entity.position().add(0.0, 0.75, 0.0);
        int range = 5;
        List items = entity.level().getEntitiesOfClass(ItemEntity.class, new AABB(pos.x - (double)range, pos.y - (double)range, pos.z - (double)range, pos.x + (double)range, pos.y + (double)range, pos.z + (double)range));
        int amountPulled = 0;
        for (ItemEntity item : items) {
            if (!item.isAlive() || item.hasPickUpDelay()) continue;
            if (amountPulled++ > 50) break;
            Vec3 motion = pos.subtract(item.position().add(0.0, (double)(item.getBbHeight() / 2.0f), 0.0));
            if (Math.sqrt(motion.x * motion.x + motion.y * motion.y + motion.z * motion.z) > 1.0) {
                motion = motion.normalize();
            }
            item.setDeltaMovement(motion.scale(0.6));
        }
    }
}

