/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.recipe.RecipeUtils;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;

public class DyeCauldronBlock
extends ModCauldronBlock {
    public static final MapCodec<DyeCauldronBlock> CODEC = DyeCauldronBlock.simpleCodec(DyeCauldronBlock::new);
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_CAULDRON;

    public DyeCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<? extends DyeCauldronBlock> codec() {
        return CODEC;
    }

    @Override
    public IntegerProperty getLevelProperty() {
        return LEVEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEVEL});
    }

    public boolean isFull(BlockState state) {
        return (Integer)state.getValue((Property)LEVEL) == 3;
    }

    protected boolean canReceiveStalactiteDrip(Fluid fluid) {
        return false;
    }

    protected double getContentHeight(BlockState state) {
        return (6.0 + (double)((Integer)state.getValue((Property)LEVEL)).intValue() * 3.0) / 16.0;
    }

    protected void receiveStalactiteDrip(BlockState state, Level level, BlockPos pos, Fluid fluid) {
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            if (te.interactWithPlayerItem(player, hand, stack)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!CommonConfigs.CAULDRON_CRAFTING.get().booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            SoftFluidTank tank = te.getSoftFluidTank();
            SoftFluidStack fluid = tank.getFluid();
            if (fluid.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                Item item = stack.getItem();
                if (item instanceof DyeItem) {
                    DyeItem di = (DyeItem)item;
                    return DyeCauldronBlock.addDye(level, te, stack, player, di);
                }
                Pair<ItemStack, Float> crafted = RecipeUtils.craftWithFluidAndDye(level, tank.getFluid(), stack);
                if (crafted != null && this.doCraftItem(level, pos, player, hand, fluid, stack, (ItemStack)crafted.getFirst(), ((Float)crafted.getSecond()).floatValue(), CommonConfigs.DYE_RECIPES_PER_LAYER.get())) {
                    te.setChanged();
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void handleEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Sheep) {
            LiquidCauldronBlockTile te;
            SoftFluidStack fluid;
            Sheep sheep = (Sheep)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LiquidCauldronBlockTile && (fluid = (te = (LiquidCauldronBlockTile)blockEntity).getSoftFluidTank().getFluid()).is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                DyeColor dye = DyeBottleItem.getClosestDye(fluid);
                if (sheep.getColor() != dye) {
                    sheep.setColor(dye);
                    te.consumeOneLayer();
                    level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
                }
            }
        }
    }

    @Override
    public BlockState updateStateOnFluidChange(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        int height = fluid.getCount();
        state = fluid.isEmpty() ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(height));
        return state;
    }

    public static void playDyeSoundAndConsume(BlockState state, BlockPos pos, Level level, Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
        }
        level.playSound(player, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.playSound(player, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.3f);
        stack.consume(1, (LivingEntity)player);
    }

    public static ItemInteractionResult addDye(Level level, LiquidCauldronBlockTile tile, ItemStack stack, Player player, DyeItem dyeItem) {
        SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
        if (!level.isClientSide()) {
            SoftFluidStack dummyStack;
            SoftFluidStack mixed;
            int count = fluid.getCount();
            if (count == 3) {
                fluid.setCount(2);
            }
            if ((mixed = LiquidMixer.mixDye(fluid, dummyStack = DyeBottleItem.createFluidStack(dyeItem.getDyeColor(), 1))) != null) {
                mixed.setCount(count);
                tile.getSoftFluidTank().setFluid(mixed);
                tile.setChanged();
            } else {
                fluid.setCount(count);
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        DyeCauldronBlock.playDyeSoundAndConsume(tile.getBlockState(), tile.getBlockPos(), level, player, stack);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

