/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.world;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.config.BiomeConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import com.github.alexthe666.alexsmobs.world.AMWorldData;
import com.github.alexthe666.alexsmobs.world.AMWorldRegistry;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

public class BeachedCachalotWhaleSpawner {
    private final Random random = new Random();
    private final ServerLevel world;
    private int timer;
    private int delay;
    private int chance;

    public BeachedCachalotWhaleSpawner(ServerLevel p_i50177_1_) {
        this.world = p_i50177_1_;
        this.timer = 1200;
        AMWorldData worldinfo = AMWorldData.get((Level)p_i50177_1_);
        this.delay = worldinfo.getBeachedCachalotSpawnDelay();
        this.chance = worldinfo.getBeachedCachalotSpawnChance();
        if (this.delay == 0 && this.chance == 0) {
            this.delay = AMConfig.beachedCachalotWhaleSpawnDelay;
            worldinfo.setBeachedCachalotSpawnDelay(this.delay);
            this.chance = 25;
            worldinfo.setBeachedCachalotSpawnChance(this.chance);
        }
    }

    public void tick() {
        if (AMConfig.beachedCachalotWhales && --this.timer <= 0 && this.world.isThundering()) {
            this.timer = 1200;
            AMWorldData worldinfo = AMWorldData.get((Level)this.world);
            this.delay -= 1200;
            if (this.delay < 0) {
                this.delay = 0;
            }
            worldinfo.setBeachedCachalotSpawnDelay(this.delay);
            if (this.delay <= 0) {
                this.delay = AMConfig.beachedCachalotWhaleSpawnDelay;
                if (this.world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
                    int i = this.chance;
                    this.chance = Mth.clamp((int)(this.chance + AMConfig.beachedCachalotWhaleSpawnChance), (int)5, (int)100);
                    worldinfo.setBeachedCachalotSpawnChance(this.chance);
                    if (this.random.nextInt(100) <= i && this.attemptSpawnWhale()) {
                        this.chance = AMConfig.beachedCachalotWhaleSpawnChance;
                    }
                }
            }
        }
    }

    private boolean attemptSpawnWhale() {
        ServerPlayer playerentity = this.world.getRandomPlayer();
        if (playerentity == null) {
            return true;
        }
        if (this.random.nextInt(5) != 0) {
            return false;
        }
        BlockPos blockpos = playerentity.blockPosition();
        BlockPos blockpos2 = this.func_221244_a(blockpos, 84);
        if (blockpos2 != null && this.func_226559_a_(blockpos2) && blockpos2.distSqr((Vec3i)blockpos) > 225.0) {
            BlockPos upPos = new BlockPos(blockpos2.getX(), blockpos2.getY() + 2, blockpos2.getZ());
            EntityCachalotWhale whale = (EntityCachalotWhale)((EntityType)AMEntityRegistry.CACHALOT_WHALE.get()).create((Level)this.world);
            whale.moveTo((double)upPos.getX() + 0.5, (double)upPos.getY() + 0.5, (double)upPos.getZ() + 0.5, this.random.nextFloat() * 360.0f - 180.0f, 0.0f);
            whale.finalizeSpawn((ServerLevelAccessor)this.world, this.world.getCurrentDifficultyAt(upPos), MobSpawnType.SPAWNER, null);
            whale.setBeached(true);
            AMWorldData worldinfo = AMWorldData.get((Level)this.world);
            worldinfo.setBeachedCachalotID(whale.getUUID());
            whale.restrictTo(upPos, 16);
            whale.setDespawnBeach(true);
            this.world.addFreshEntity((Entity)whale);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos func_221244_a(BlockPos p_221244_1_, int p_221244_2_) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = p_221244_1_.getX() + this.random.nextInt(p_221244_2_ * 2) - p_221244_2_;
            BlockPos blockpos1 = new BlockPos(j, l = this.world.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = p_221244_1_.getZ() + this.random.nextInt(p_221244_2_ * 2) - p_221244_2_), k);
            if (!AMWorldRegistry.testBiome(BiomeConfig.cachalot_whale_beached_spawns, (Holder<Biome>)this.world.getBiome(blockpos1))) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean func_226559_a_(BlockPos p_226559_1_) {
        BlockPos blockpos;
        Iterator var2 = BlockPos.betweenClosed((BlockPos)p_226559_1_, (BlockPos)p_226559_1_.offset(1, 2, 1)).iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while (this.world.getBlockState(blockpos = (BlockPos)var2.next()).getBlockSupportShape((BlockGetter)this.world, blockpos).isEmpty() && this.world.getFluidState(blockpos).isEmpty());
        return false;
    }
}

