/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.tileentity;

import com.github.alexthe666.alexsmobs.block.BlockVoidWormBeak;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TileEntityVoidWormBeak
extends BlockEntity {
    private float chompProgress;
    private float prevChompProgress;
    public int ticksExisted;

    public TileEntityVoidWormBeak(BlockPos pos, BlockState state) {
        super((BlockEntityType)AMTileEntityRegistry.VOID_WORM_BEAK.get(), pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileEntityVoidWormBeak entity) {
        entity.tick();
    }

    public void tick() {
        this.prevChompProgress = this.chompProgress;
        boolean powered = false;
        if (this.getBlockState().getBlock() instanceof BlockVoidWormBeak) {
            powered = (Boolean)this.getBlockState().getValue((Property)BlockVoidWormBeak.POWERED);
        }
        if (powered && this.chompProgress < 5.0f) {
            this.chompProgress += 1.0f;
        }
        if (!powered && this.chompProgress > 0.0f) {
            this.chompProgress -= 1.0f;
        }
        if (this.chompProgress >= 5.0f && !this.level.isClientSide && this.ticksExisted % 5 == 0) {
            float i = (float)this.getBlockPos().getX() + 0.5f;
            float j = (float)this.getBlockPos().getY() + 0.5f;
            float k = (float)this.getBlockPos().getZ() + 0.5f;
            float d0 = 0.5f;
            for (LivingEntity entity : this.level.getEntitiesOfClass(LivingEntity.class, new AABB((double)i - (double)d0, (double)j - (double)d0, (double)k - (double)d0, (double)i + (double)d0, (double)j + (double)d0, (double)k + (double)d0))) {
                entity.hurt(entity.damageSources().generic(), 5.0f);
            }
        }
        ++this.ticksExisted;
    }

    public float getChompProgress(float partialTick) {
        return this.prevChompProgress + (this.chompProgress - this.prevChompProgress) * partialTick;
    }
}

