/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.tileentity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.TransmutationData;
import com.github.alexthe666.alexsmobs.network.MessageUpdateTransmutablesToDisplay;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class TileEntityTransmutationTable
extends BlockEntity {
    private static final ResourceLocation COMMON_ITEMS = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"gameplay/transmutation_table_common");
    private static final ResourceLocation UNCOMMON_ITEMS = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"gameplay/transmutation_table_uncommon");
    private static final ResourceLocation RARE_ITEMS = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"gameplay/transmutation_table_rare");
    public int ticksExisted;
    private int totalTransmuteCount = 0;
    private final Map<UUID, TransmutationData> playerToData = new HashMap<UUID, TransmutationData>();
    private final ItemStack[] possiblities = new ItemStack[3];
    private static final Random RANDOM = new Random();
    private UUID rerollPlayerUUID = null;

    public TileEntityTransmutationTable(BlockPos pos, BlockState state) {
        super((BlockEntityType)AMTileEntityRegistry.TRANSMUTATION_TABLE.get(), pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileEntityTransmutationTable entity) {
        entity.tick();
    }

    private static ItemStack createFromLootTable(Player player, ResourceLocation loc) {
        if (player.level().isClientSide) {
            return ItemStack.EMPTY;
        }
        LootTable loottable = player.level().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)loc));
        ObjectArrayList loots = loottable.getRandomItems(new LootParams.Builder((ServerLevel)player.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.EMPTY));
        return loots.isEmpty() ? ItemStack.EMPTY : (ItemStack)loots.get(0);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.totalTransmuteCount = tag.getInt("TotalCount");
        ListTag list = new ListTag();
        for (Map.Entry<UUID, TransmutationData> entry : this.playerToData.entrySet()) {
            CompoundTag innerTag = new CompoundTag();
            innerTag.putUUID("UUID", entry.getKey());
            innerTag.put("TransmutationData", (Tag)entry.getValue().saveAsNBT(provider));
            list.add((Object)innerTag);
        }
        tag.put("PlayerTransmutationData", (Tag)list);
        for (int i = 0; i < 3; ++i) {
            if (!tag.contains("Possibility" + i)) continue;
            this.possiblities[i] = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("Possiblity" + i));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        int i;
        super.saveAdditional(tag, provider);
        tag.putInt("TotalCount", this.totalTransmuteCount);
        ListTag list = tag.getList("PlayerTransmutationData", 10);
        if (!list.isEmpty()) {
            for (i = 0; i < list.size(); ++i) {
                CompoundTag compoundtag = list.getCompound(i);
                UUID uuid = compoundtag.getUUID("UUID");
                if (uuid == null) continue;
                this.playerToData.put(uuid, TransmutationData.fromNBT(compoundtag.getCompound("TransmutationData")));
            }
        }
        for (i = 0; i < 3; ++i) {
            if (this.possiblities[i] == null || this.possiblities[i].isEmpty()) continue;
            tag.put("Possiblity" + i, this.possiblities[i].save(provider));
        }
    }

    private void randomizeResults(Player player) {
        this.rollPossiblity(player, 0);
        this.rollPossiblity(player, 1);
        this.rollPossiblity(player, 2);
        int dataIndex = RANDOM.nextInt(2);
        if (this.playerToData.containsKey(player.getUUID()) && !AMConfig.limitTransmutingToLootTables) {
            ItemStack stack;
            TransmutationData data = this.playerToData.get(player.getUUID());
            if ((double)RANDOM.nextFloat() < Math.min((double)0.01875f * data.getTotalWeight(), (double)0.2f) && (stack = data.getRandomItem(RANDOM)) != null && !stack.isEmpty()) {
                this.possiblities[dataIndex] = stack;
            }
        }
        AlexsMobs.sendMSGToAll(new MessageUpdateTransmutablesToDisplay(player.getId(), this.possiblities[0], this.possiblities[1], this.possiblities[2]));
    }

    public void rollPossiblity(Player player, int i) {
        if (player == null || player.level().isClientSide || !(player.level() instanceof ServerLevel)) {
            return;
        }
        int safeIndex = Mth.clamp((int)i, (int)0, (int)2);
        this.possiblities[safeIndex] = TileEntityTransmutationTable.createFromLootTable(player, switch (safeIndex) {
            default -> COMMON_ITEMS;
            case 1 -> UNCOMMON_ITEMS;
            case 2 -> RARE_ITEMS;
        });
    }

    public boolean hasPossibilities() {
        for (int i = 0; i < 3; ++i) {
            if (this.possiblities[i] != null && !this.possiblities[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getPossibility(int i) {
        int safeIndex = Mth.clamp((int)i, (int)0, (int)2);
        ItemStack possible = this.possiblities[safeIndex];
        return possible == null ? ItemStack.EMPTY : possible;
    }

    public void postTransmute(Player player, ItemStack from, ItemStack to) {
        TransmutationData data = this.playerToData.containsKey(player.getUUID()) ? this.playerToData.get(player.getUUID()) : new TransmutationData();
        data.onTransmuteItem(from, to);
        this.playerToData.put(player.getUUID(), data);
        this.totalTransmuteCount += from.getCount();
        if (player instanceof ServerPlayer && this.totalTransmuteCount >= 1000) {
            ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.TRANSMUTE_1000_ITEMS.get())).trigger((ServerPlayer)player);
        }
        this.setRerollPlayerUUID(player.getUUID());
    }

    public void tick() {
        ++this.ticksExisted;
        if (this.rerollPlayerUUID != null) {
            Player player = this.level.getPlayerByUUID(this.rerollPlayerUUID);
            if (player != null) {
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)AMSoundRegistry.TRANSMUTE_ITEM.get(), SoundSource.BLOCKS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
                this.randomizeResults(player);
            }
            this.rerollPlayerUUID = null;
        }
    }

    public void setRerollPlayerUUID(UUID uuid) {
        this.rerollPlayerUUID = uuid;
    }
}

