/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.tileentity;

import com.github.alexthe666.alexsmobs.entity.EntityTerrapin;
import com.github.alexthe666.alexsmobs.entity.util.TerrapinTypes;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityTerrapinEgg
extends BlockEntity {
    public ParentData parent1;
    public ParentData parent2;

    public TileEntityTerrapinEgg(BlockPos pos, BlockState state) {
        super((BlockEntityType)AMTileEntityRegistry.TERRAPIN_EGG.get(), pos, state);
    }

    public void addAttributesToOffspring(EntityTerrapin baby, RandomSource random) {
        if (this.parent1 != null && this.parent2 != null) {
            baby.setTurtleType(random.nextBoolean() ? this.parent1.type : this.parent2.type);
            baby.setShellType(random.nextBoolean() ? this.parent1.shellType : this.parent2.shellType);
            baby.setSkinType(random.nextBoolean() ? this.parent1.skinType : this.parent2.skinType);
            baby.setTurtleColor((this.parent1.turtleColor + this.parent2.turtleColor) / 2);
            baby.setShellColor((this.parent1.shellColor + this.parent2.shellColor) / 2);
            baby.setSkinColor((this.parent1.skinColor + this.parent2.skinColor) / 2);
            if (random.nextFloat() < 0.15f) {
                baby.setTurtleType(TerrapinTypes.OVERLAY);
                switch (random.nextInt(2)) {
                    case 0: {
                        baby.setTurtleColor((int)(1.6777215E7f * random.nextFloat()));
                        break;
                    }
                    case 1: {
                        baby.setShellColor((int)(1.6777215E7f * random.nextFloat()));
                        break;
                    }
                    case 2: {
                        baby.setSkinColor((int)(1.6777215E7f * random.nextFloat()));
                    }
                }
            }
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        if (compound.contains("Parent1Data")) {
            this.parent1 = new ParentData(compound.getCompound("Parent1Data"));
        }
        if (compound.contains("Parent2Data")) {
            this.parent2 = new ParentData(compound.getCompound("Parent2Data"));
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        CompoundTag tag;
        super.saveAdditional(compound, registries);
        if (this.parent1 != null) {
            tag = new CompoundTag();
            this.parent1.writeToNBT(tag);
            compound.put("Parent1Data", (Tag)tag);
        }
        if (this.parent2 != null) {
            tag = new CompoundTag();
            this.parent2.writeToNBT(tag);
            compound.put("Parent2Data", (Tag)tag);
        }
    }

    public static class ParentData {
        public TerrapinTypes type;
        public int shellType;
        public int skinType;
        public int turtleColor;
        public int shellColor;
        public int skinColor;

        public ParentData(TerrapinTypes type, int shellType, int skinType, int turtleColor, int shellColor, int skinColor) {
            this.type = type;
            this.shellType = shellType;
            this.skinType = skinType;
            this.turtleColor = turtleColor;
            this.shellColor = shellColor;
            this.skinColor = skinColor;
        }

        public ParentData(CompoundTag tag) {
            this(TerrapinTypes.values()[Mth.clamp((int)tag.getInt("TerrapinType"), (int)0, (int)(TerrapinTypes.values().length - 1))], tag.getInt("ShellType"), tag.getInt("SkinType"), tag.getInt("TurtleColor"), tag.getInt("ShellColor"), tag.getInt("SkinColor"));
        }

        public boolean canMerge(ParentData other) {
            if (this.type == TerrapinTypes.OVERLAY && other.type == TerrapinTypes.OVERLAY) {
                return this.turtleColor == other.turtleColor && this.shellType == other.shellType && this.skinType == other.skinType && this.shellColor == other.shellColor && this.skinColor == other.skinColor;
            }
            return other.type == this.type;
        }

        public void writeToNBT(CompoundTag tag) {
            tag.putInt("TerrapinType", this.type.ordinal());
            tag.putInt("ShellType", this.shellType);
            tag.putInt("SkinType", this.skinType);
            tag.putInt("TurtleColor", this.turtleColor);
            tag.putInt("ShellColor", this.shellColor);
            tag.putInt("SkinColor", this.skinColor);
        }
    }
}

