/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.network;

import com.github.alexthe666.alexsmobs.entity.EntityStraddleboard;
import com.github.alexthe666.alexsmobs.entity.IFalconry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageSyncEntityPos(int entityId, double x, double y, double z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageSyncEntityPos> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"sync_entity_pos"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSyncEntityPos> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MessageSyncEntityPos>(){

        public MessageSyncEntityPos decode(RegistryFriendlyByteBuf buf) {
            int entityId = buf.readInt();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            return new MessageSyncEntityPos(entityId, x, y, z);
        }

        public void encode(RegistryFriendlyByteBuf buf, MessageSyncEntityPos packet) {
            buf.writeInt(packet.entityId);
            buf.writeDouble(packet.x);
            buf.writeDouble(packet.y);
            buf.writeDouble(packet.z);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handleClient(MessageSyncEntityPos payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.entityId);
            if (entity instanceof IFalconry || entity instanceof EntityStraddleboard) {
                entity.setPos(payload.x, payload.y, payload.z);
                entity.teleportTo(payload.x, payload.y, payload.z);
            }
        });
    }
}

