/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMRecipeRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class RecipeMimicreamRepair
extends CustomRecipe {
    public RecipeMimicreamRepair(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        if (!AMConfig.mimicreamRepair) {
            return false;
        }
        ItemStack damageableStack = ItemStack.EMPTY;
        int mimicreamCount = 0;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack1 = inv.getItem(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.isDamageableItem() && !this.isBlacklisted(itemstack1)) {
                damageableStack = itemstack1;
                continue;
            }
            if (itemstack1.getItem() != AMItemRegistry.MIMICREAM.get()) continue;
            ++mimicreamCount;
        }
        return !damageableStack.isEmpty() && mimicreamCount >= 8;
    }

    public boolean isBlacklisted(ItemStack stack) {
        ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return name != null && AMConfig.mimicreamBlacklist.contains(name.toString());
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack damageableStack = ItemStack.EMPTY;
        int mimicreamCount = 0;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack1 = inv.getItem(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.isDamageableItem() && !this.isBlacklisted(itemstack1)) {
                damageableStack = itemstack1;
                continue;
            }
            if (itemstack1.getItem() != AMItemRegistry.MIMICREAM.get()) continue;
            ++mimicreamCount;
        }
        if (!damageableStack.isEmpty() && mimicreamCount >= 8) {
            ItemStack itemstack2 = damageableStack.copy();
            CompoundTag compoundnbt = new CompoundTag();
            if (damageableStack.is((Item)AMItemRegistry.GHOSTLY_PICKAXE.get()) && compoundnbt.contains("Items")) {
                compoundnbt.remove("Items");
            }
            ListTag oldNBTList = compoundnbt.getList("Enchantments", 10);
            ListTag newNBTList = new ListTag();
            ResourceLocation mendingName = ResourceLocation.withDefaultNamespace((String)"mending");
            for (int i = 0; i < oldNBTList.size(); ++i) {
                CompoundTag compoundnbt2 = oldNBTList.getCompound(i);
                ResourceLocation resourcelocation1 = ResourceLocation.tryParse((String)compoundnbt2.getString("id"));
                if (resourcelocation1 != null && resourcelocation1.equals((Object)mendingName)) continue;
                newNBTList.add((Object)compoundnbt2);
            }
            compoundnbt.put("Enchantments", (Tag)newNBTList);
            itemstack2.setDamageValue(itemstack2.getMaxDamage());
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (!itemstack.isDamageableItem()) continue;
            ItemStack itemstack1 = itemstack.copy();
            itemstack1.setCount(1);
            nonnulllist.set(i, (Object)itemstack1);
            break;
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AMRecipeRegistry.MIMICREAM_RECIPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

