/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class BlossomLootModifier
implements IGlobalLootModifier {
    public static final Supplier<MapCodec<BlossomLootModifier>> CODEC = () -> MapCodec.unit(() -> new BlossomLootModifier(new LootItemCondition[0]));
    private static final ResourceLocation ACACIA_LEAVES = ResourceLocation.withDefaultNamespace((String)"blocks/acacia_leaves");
    private final LootItemCondition[] conditions;

    public BlossomLootModifier(LootItemCondition[] conditionsIn) {
        this.conditions = conditionsIn;
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation lootTableId = context.getQueriedLootTableId();
        if (lootTableId.equals((Object)ACACIA_LEAVES)) {
            return this.doApply(generatedLoot, context);
        }
        return generatedLoot;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (AMConfig.acaciaBlossomsDropFromLeaves) {
            int blossomStep;
            int silkTouch;
            ItemStack ctxTool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
            RandomSource random = context.getRandom();
            if (ctxTool != null && ((silkTouch = ctxTool.getEnchantmentLevel((Holder)context.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH))) > 0 || ctxTool.getItem() instanceof ShearsItem)) {
                return generatedLoot;
            }
            int bonusLevel = ctxTool != null ? 0 : 0;
            int blossomRarity = AMConfig.acaciaBlossomChance - bonusLevel * (blossomStep = (int)Math.floor((float)AMConfig.acaciaBlossomChance * 0.1f));
            if (blossomRarity < 1 || random.nextInt(blossomRarity) == 0) {
                generatedLoot.add((Object)new ItemStack((ItemLike)AMItemRegistry.ACACIA_BLOSSOM.get()));
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

