/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class AncientDartLootModifier
implements IGlobalLootModifier {
    public static final Supplier<MapCodec<AncientDartLootModifier>> CODEC = () -> MapCodec.unit(() -> new AncientDartLootModifier(new LootItemCondition[0]));
    private static final ResourceLocation JUNGLE_TEMPLE = ResourceLocation.withDefaultNamespace((String)"chests/jungle_temple");
    private static final ResourceLocation JUNGLE_TEMPLE_DISPENSER = ResourceLocation.withDefaultNamespace((String)"chests/jungle_temple_dispenser");
    private final LootItemCondition[] conditions;

    public AncientDartLootModifier(LootItemCondition[] conditionsIn) {
        this.conditions = conditionsIn;
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ResourceLocation lootTableId = context.getQueriedLootTableId();
        if (lootTableId.equals((Object)JUNGLE_TEMPLE) || lootTableId.equals((Object)JUNGLE_TEMPLE_DISPENSER)) {
            return this.doApply(generatedLoot, context);
        }
        return generatedLoot;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (AMConfig.addLootToChests) {
            generatedLoot.add((Object)new ItemStack((ItemLike)AMItemRegistry.ANCIENT_DART.get()));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

