/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.EntityStraddleboard;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemStraddleboard
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private static final int DEFAULT_COLOR = 11387863;

    public ItemStraddleboard(Item.Properties properties) {
        super(properties);
    }

    public int getColor(ItemStack stack) {
        DyedItemColor dyedColor = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        return dyedColor != null ? dyedColor.rgb() : 11387863;
    }

    public boolean hasCustomColor(ItemStack stack) {
        return stack.has(DataComponents.DYED_COLOR);
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult raytraceresult = ItemStraddleboard.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vector3d = playerIn.getViewVector(1.0f);
        double d0 = 5.0;
        List list = worldIn.getEntities((Entity)playerIn, playerIn.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vector3d1 = playerIn.getEyePosition(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!axisalignedbb.contains(vector3d1)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            EntityStraddleboard boatentity = new EntityStraddleboard(worldIn, raytraceresult.getLocation().x, raytraceresult.getLocation().y, raytraceresult.getLocation().z);
            boatentity.setDefaultColor(!this.hasCustomColor(itemstack));
            boatentity.setItemStack(itemstack.copy());
            boatentity.setColor(this.getColor(itemstack));
            boatentity.setYRot(playerIn.getYRot());
            if (!worldIn.noCollision((Entity)boatentity, boatentity.getBoundingBox().inflate(-0.1))) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!worldIn.isClientSide) {
                worldIn.addFreshEntity((Entity)boatentity);
                if (!playerIn.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)worldIn.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

