/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.util.RainbowUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemRainbowJelly
extends Item {
    public ItemRainbowJelly(Item.Properties tab) {
        super(tab);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        int i = RainbowUtil.getRainbowTypeFromStack(stack);
        if (RainbowUtil.getRainbowType(target) != i) {
            RainbowUtil.setRainbowType(target, i);
            RandomSource random = playerIn.getRandom();
            for (int j = 0; j < 6 + random.nextInt(3); ++j) {
                double d2 = random.nextGaussian() * 0.02;
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                playerIn.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), target.getX() + (double)(random.nextFloat() * target.getBbWidth()) - (double)target.getBbWidth() * 0.5, target.getY() + (double)(target.getBbHeight() * 0.5f) + (double)(random.nextFloat() * target.getBbHeight() * 0.5f), target.getZ() + (double)(random.nextFloat() * target.getBbWidth()) - (double)target.getBbWidth() * 0.5, d0, d1, d2);
            }
            target.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
            target.playSound(SoundEvents.SLIME_SQUISH_SMALL, 1.0f, target.getVoicePitch());
            if (!playerIn.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack finishUsingItem(ItemStack st, Level level, LivingEntity e) {
        RainbowUtil.setRainbowType(e, RainbowUtil.getRainbowTypeFromStack(st));
        return st.has(DataComponents.FOOD) ? e.eat(level, st) : st;
    }

    public int getUseDuration(ItemStack stack) {
        if (stack.has(DataComponents.FOOD)) {
            return 64;
        }
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || RainbowUtil.getRainbowTypeFromStack(stack) > 1;
    }

    public static enum RainbowType {
        RAINBOW,
        TRANS,
        NONBI,
        BI,
        ACE,
        WEEZER,
        BRAZIL;


        public static RainbowType getFromString(String name) {
            if (name.contains("nonbi") || name.contains("non-bi")) {
                return NONBI;
            }
            if (name.contains("trans")) {
                return TRANS;
            }
            if (name.contains("bi")) {
                return BI;
            }
            if (name.contains("asexual") || name.contains("ace")) {
                return ACE;
            }
            if (name.contains("weezer")) {
                return WEEZER;
            }
            if (name.contains("brazil")) {
                return BRAZIL;
            }
            return RAINBOW;
        }
    }
}

