/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ItemGhostlyPickaxe
extends PickaxeItem {
    public ItemGhostlyPickaxe(Item.Properties props) {
        super((Tier)Tiers.IRON, props);
    }

    public static boolean shouldStoreInGhost(LivingEntity player, ItemStack stack) {
        return player instanceof Player && ((Player)player).getInventory().getFreeSlot() == -1;
    }

    public float getDestroySpeed(ItemStack stack, BlockState blockState) {
        return blockState.is(BlockTags.MINEABLE_WITH_PICKAXE) ? 20.0f : 1.0f;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity user) {
        if (ItemGhostlyPickaxe.shouldStoreInGhost(user, stack)) {
            if (user instanceof Player) {
                Player player = (Player)user;
                player.awardStat(Stats.BLOCK_MINED.get((Object)state.getBlock()));
                player.causeFoodExhaustion(0.005f);
            }
            if (!level.isClientSide) {
                BlockEntity blockentity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
                Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)blockentity, (Entity)user, (ItemStack)stack).forEach(item -> ItemGhostlyPickaxe.putItemInGhostInventoryOrDrop(user, stack, item));
                state.spawnAfterBreak((ServerLevel)level, pos, stack, true);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                int exp = state.getExpDrop((LevelAccessor)((ServerLevel)level), pos, blockEntity, (Entity)user, stack);
                if (exp > 0) {
                    state.getBlock().popExperience((ServerLevel)level, pos, exp);
                }
            }
        }
        return super.mineBlock(stack, level, state, pos, user);
    }

    private static void putItemInGhostInventoryOrDrop(LivingEntity user, ItemStack pickaxe, ItemStack item) {
        CompoundTag compoundtag = ((CustomData)pickaxe.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        SimpleContainer container = new SimpleContainer(9);
        if (compoundtag.contains("Items")) {
            // empty if block
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (player.getInventory().add(item)) {
                return;
            }
            if (container.canAddItem(item)) {
                ItemStack leftover = container.addItem(item);
                compoundtag.put("Items", (Tag)new ListTag());
                item = leftover;
            }
        }
        if (!item.isEmpty()) {
            user.spawnAtLocation(item);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean offhand) {
        super.inventoryTick(stack, level, entity, i, offhand);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.tickCount % 3 == 0) {
                CompoundTag compoundtag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                SimpleContainer container = new SimpleContainer(9);
                boolean flag = false;
                if (compoundtag.contains("Items")) {
                    // empty if block
                }
                for (int slot = 0; slot < container.getContainerSize(); ++slot) {
                    ItemStack stackAt = container.getItem(slot);
                    if (stackAt.isEmpty() || !player.addItem(stackAt)) continue;
                    container.removeItem(slot, stack.getCount());
                    flag = true;
                    break;
                }
                if (flag) {
                    compoundtag.put("Items", (Tag)new ListTag());
                }
            }
        }
    }

    public boolean isValidRepairItem(ItemStack pickaxe, ItemStack stack) {
        return stack.is(Items.PHANTOM_MEMBRANE);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Object compoundtag = null;
        if (compoundtag != null && compoundtag.contains("Items", 9)) {
            SimpleContainer container = new SimpleContainer(9);
            int i = 0;
            int j = 0;
            for (int slot = 0; slot < container.getContainerSize(); ++slot) {
                ItemStack itemstack = container.getItem(slot);
                if (itemstack.isEmpty()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                MutableComponent mutablecomponent = itemstack.getHoverName().copy();
                mutablecomponent.append(" x").append(String.valueOf(itemstack.getCount()));
                tooltip.add((Component)mutablecomponent.withStyle(ChatFormatting.DARK_AQUA));
            }
            if (j - i > 0) {
                tooltip.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).withStyle(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.ITALIC}));
            }
        }
    }

    private void dropAllContents(Level level, Vec3 vec3, ItemStack pickaxe) {
        Object compoundtag = null;
        if (compoundtag != null && compoundtag.contains("Items", 9)) {
            SimpleContainer container = new SimpleContainer(9);
            for (int slot = 0; slot < container.getContainerSize(); ++slot) {
                ItemEntity itemEntity;
                ItemStack itemstack = container.getItem(slot);
                if (itemstack.isEmpty() || !level.addFreshEntity((Entity)(itemEntity = new ItemEntity(level, vec3.x, vec3.y, vec3.z, itemstack.copy())))) continue;
                container.removeItem(slot, itemstack.getCount());
            }
            compoundtag.put("Items", (Tag)new ListTag());
        }
    }

    public void onDestroyed(ItemEntity itemEntity) {
        this.dropAllContents(itemEntity.level(), itemEntity.position(), itemEntity.getItem());
    }

    public int getMaxDamage(ItemStack stack) {
        return 700;
    }
}

