/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.util;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.network.MessageSyncEntityData;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VineLassoUtil {
    private static final String LASSO_PACKET = "LassoSentPacketAlexsMobs";
    private static final String LASSO_REMOVED = "LassoRemovedAlexsMobs";
    private static final String LASSOED_TO_TAG = "LassoOwnerAlexsMobs";
    private static final String LASSOED_TO_ENTITY_ID_TAG = "LassoOwnerIDAlexsMobs";

    public static void lassoTo(@Nullable LivingEntity lassoer, LivingEntity lassoed) {
        CompoundTag lassoedTag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)lassoed);
        if (lassoer == null) {
            lassoedTag.putUUID(LASSOED_TO_TAG, UUID.randomUUID());
            lassoedTag.putInt(LASSOED_TO_ENTITY_ID_TAG, -1);
            lassoedTag.putBoolean(LASSO_REMOVED, true);
        } else {
            lassoedTag.putUUID(LASSOED_TO_TAG, lassoer.getUUID());
            lassoedTag.putInt(LASSOED_TO_ENTITY_ID_TAG, lassoer.getId());
            lassoedTag.putBoolean(LASSO_REMOVED, false);
        }
        lassoedTag.putBoolean(LASSO_PACKET, true);
        CitadelEntityData.setCitadelTag((LivingEntity)lassoed, (CompoundTag)lassoedTag);
        if (!lassoed.level().isClientSide) {
            AlexsMobs.sendMSGToAll(new MessageSyncEntityData(lassoed.getId(), lassoedTag));
        }
    }

    public static boolean hasLassoData(LivingEntity lasso) {
        CompoundTag lassoedTag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)lasso);
        if (lassoedTag.getBoolean(LASSO_REMOVED)) {
            return false;
        }
        boolean hasEntityId = lassoedTag.contains(LASSOED_TO_ENTITY_ID_TAG) && lassoedTag.getInt(LASSOED_TO_ENTITY_ID_TAG) != -1;
        boolean hasUuid = lassoedTag.hasUUID(LASSOED_TO_TAG);
        return hasEntityId || hasUuid;
    }

    public static Entity getLassoedTo(LivingEntity lassoed) {
        CompoundTag lassoedTag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)lassoed);
        if (lassoedTag.getBoolean(LASSO_REMOVED)) {
            return null;
        }
        if (VineLassoUtil.hasLassoData(lassoed)) {
            UUID uuid;
            Entity found;
            int entityId;
            int n = entityId = lassoedTag.contains(LASSOED_TO_ENTITY_ID_TAG) ? lassoedTag.getInt(LASSOED_TO_ENTITY_ID_TAG) : -1;
            if (entityId != -1 && (found = lassoed.level().getEntity(entityId)) != null) {
                return found;
            }
            UUID uUID = uuid = lassoedTag.hasUUID(LASSOED_TO_TAG) ? lassoedTag.getUUID(LASSOED_TO_TAG) : null;
            if (uuid != null) {
                ServerLevel serverLevel;
                Entity found2;
                Level level = lassoed.level();
                if (level instanceof ServerLevel && (found2 = (serverLevel = (ServerLevel)level).getEntity(uuid)) != null) {
                    lassoedTag.putInt(LASSOED_TO_ENTITY_ID_TAG, found2.getId());
                    return found2;
                }
                if (lassoed.level().isClientSide) {
                    return lassoed.level().getPlayerByUUID(uuid);
                }
            }
        }
        return null;
    }

    public static void tickLasso(LivingEntity lassoed) {
        Entity lassoedOwner;
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)lassoed);
        if (!lassoed.level().isClientSide && (tag.contains(LASSO_PACKET) || tag.getBoolean(LASSO_REMOVED))) {
            tag.putBoolean(LASSO_PACKET, false);
            CitadelEntityData.setCitadelTag((LivingEntity)lassoed, (CompoundTag)tag);
            AlexsMobs.sendMSGToAll(new MessageSyncEntityData(lassoed.getId(), tag));
        }
        if ((lassoedOwner = VineLassoUtil.getLassoedTo(lassoed)) != null) {
            double distance = lassoed.distanceTo(lassoedOwner);
            if (lassoed instanceof Mob) {
                Mob mob = (Mob)lassoed;
                if (distance > 3.0) {
                    mob.getNavigation().moveTo(lassoedOwner, 1.0);
                } else {
                    mob.getNavigation().stop();
                }
            }
            if (distance > 10.0) {
                double d0 = (lassoedOwner.getX() - lassoed.getX()) / distance;
                double d1 = (lassoedOwner.getY() - lassoed.getY()) / distance;
                double d2 = (lassoedOwner.getZ() - lassoed.getZ()) / distance;
                double yd = Math.copySign(d1 * d1 * 0.4, d1);
                if (lassoed instanceof Player) {
                    yd = 0.0;
                }
                lassoed.setDeltaMovement(lassoed.getDeltaMovement().add(Math.copySign(d0 * d0 * 0.4, d0), yd, Math.copySign(d2 * d2 * 0.4, d2)));
            }
        }
    }
}

