/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.util;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.item.ItemRainbowJelly;
import com.github.alexthe666.alexsmobs.misc.AMSimplexNoise;
import com.github.alexthe666.alexsmobs.network.MessageSyncEntityData;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RainbowUtil {
    private static final String RAINBOW_TYPE = "RainbowTypeAlexsMobs";

    public static void setRainbowType(LivingEntity fabulous, int type) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)fabulous);
        tag.putInt(RAINBOW_TYPE, type);
        CitadelEntityData.setCitadelTag((LivingEntity)fabulous, (CompoundTag)tag);
        if (!fabulous.level().isClientSide) {
            AlexsMobs.sendMSGToAll(new MessageSyncEntityData(fabulous.getId(), tag));
        }
    }

    public static int getRainbowType(LivingEntity entity) {
        CompoundTag lassoedTag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (lassoedTag.contains(RAINBOW_TYPE)) {
            return lassoedTag.getInt(RAINBOW_TYPE);
        }
        return 0;
    }

    public static int getRainbowTypeFromStack(ItemStack stack) {
        String name = stack.getDisplayName().getString().toLowerCase(Locale.ROOT);
        return ItemRainbowJelly.RainbowType.getFromString(name).ordinal() + 1;
    }

    public static int calculateGlassColor(BlockPos pos) {
        float f = (float)AMConfig.rainbowGlassFidelity;
        float f1 = (float)((AMSimplexNoise.noise(((float)pos.getX() + f) / f, ((float)pos.getY() + f) / f, ((float)pos.getZ() + f) / f) + 1.0) * 0.5);
        return Color.HSBtoRGB(f1, 1.0f, 1.0f);
    }
}

