/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.util;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.network.MessageSyncEntityData;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FlyingFishBootsUtil {
    private static final String BOOST_TICKS = "FlyingFishBoostAlexsMobs";
    private static final int MIN_BOOST_TIME = 35;

    public static void setBoostTicks(LivingEntity entity, int ticks) {
        CompoundTag lassoedTag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        lassoedTag.putInt(BOOST_TICKS, ticks);
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)lassoedTag);
        if (!entity.level().isClientSide) {
            AlexsMobs.sendMSGToAll(new MessageSyncEntityData(entity.getId(), lassoedTag));
        }
    }

    public static int getBoostTicks(LivingEntity entity) {
        CompoundTag lassoedTag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (lassoedTag.contains(BOOST_TICKS)) {
            return lassoedTag.getInt(BOOST_TICKS);
        }
        return 0;
    }

    public static boolean isWearing(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.FEET).getItem() == AMItemRegistry.FLYING_FISH_BOOTS.get();
    }

    public static void tickFlyingFishBoots(LivingEntity fishy) {
        int boostTime = FlyingFishBootsUtil.getBoostTicks(fishy);
        if (boostTime <= 15 && fishy.isInWaterOrBubble() && !fishy.onGround() && fishy.getFluidHeight(FluidTags.WATER) < (double)0.4f && fishy.getDeltaMovement().y > 0.0 && (!(fishy instanceof Player) || !((Player)fishy).getAbilities().flying)) {
            RandomSource rand = fishy.getRandom();
            boostTime = 35;
            Vec3 forward = new Vec3(0.0, 0.0, (double)(0.5f + rand.nextFloat() * 1.2f)).xRot(-fishy.getXRot() * ((float)Math.PI / 180)).yRot(-fishy.getYHeadRot() * ((float)Math.PI / 180));
            Vec3 delta = fishy.getDeltaMovement().add(forward);
            fishy.setDeltaMovement(delta.x, 0.3 + (double)(rand.nextFloat() * 0.3f), delta.z);
            fishy.setYRot(fishy.getYHeadRot());
        }
        if (boostTime > 0) {
            if (!fishy.isInWaterOrBubble() && !fishy.onGround()) {
                if (fishy.getDeltaMovement().y < 0.0) {
                    fishy.setDeltaMovement(fishy.getDeltaMovement().multiply(1.0, 0.75, 1.0));
                }
                fishy.setPose(Pose.FALL_FLYING);
            }
            FlyingFishBootsUtil.setBoostTicks(fishy, boostTime - 1);
        }
    }
}

