/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class TameableAIRide
extends Goal {
    private final PathfinderMob tameableEntity;
    private LivingEntity player;
    private final double speed;
    private final boolean strafe;

    public TameableAIRide(PathfinderMob dragon, double speed) {
        this(dragon, speed, true);
    }

    public TameableAIRide(PathfinderMob dragon, double speed, boolean strafe) {
        this.tameableEntity = dragon;
        this.speed = speed;
        this.strafe = strafe;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.tameableEntity.getControllingPassenger() instanceof Player && this.tameableEntity.isVehicle()) {
            this.player = (Player)this.tameableEntity.getControllingPassenger();
            return true;
        }
        this.tameableEntity.setSprinting(false);
        return false;
    }

    public void start() {
        this.tameableEntity.getNavigation().stop();
    }

    public void tick() {
        this.tameableEntity.getNavigation().stop();
        this.tameableEntity.setTarget(null);
        double x = this.tameableEntity.getX();
        double y = this.tameableEntity.getY();
        double z = this.tameableEntity.getZ();
        if (this.strafe) {
            this.tameableEntity.xxa = this.player.xxa * 0.15f;
        }
        if (this.shouldMoveForward() && this.tameableEntity.isVehicle()) {
            this.tameableEntity.setSprinting(true);
            Vec3 lookVec = this.player.getLookAngle();
            if (this.shouldMoveBackwards()) {
                lookVec = lookVec.yRot((float)Math.PI);
            }
            this.tameableEntity.getMoveControl().setWantedPosition(x += lookVec.x * 10.0, y += this.modifyYPosition(lookVec.y), z += lookVec.z * 10.0, this.speed);
        } else {
            this.tameableEntity.setSprinting(false);
        }
    }

    public double modifyYPosition(double lookVecY) {
        return this.tameableEntity instanceof FlyingAnimal ? lookVecY * 10.0 : 0.0;
    }

    public boolean shouldMoveForward() {
        return this.player.zza != 0.0f;
    }

    public boolean shouldMoveBackwards() {
        return this.player.zza < 0.0f;
    }
}

