/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class TameableAIDestroyTurtleEggs
extends RemoveBlockGoal {
    public TameableAIDestroyTurtleEggs(TamableAnimal creatureIn, double speed, int yMax) {
        super(Blocks.TURTLE_EGG, (PathfinderMob)creatureIn, speed, yMax);
        this.nextStartTick = 800;
    }

    public boolean canUse() {
        return !((TamableAnimal)this.mob).isTame() && super.canUse();
    }

    public boolean canContinueToUse() {
        return !((TamableAnimal)this.mob).isTame() && super.canContinueToUse();
    }

    public void playDestroyProgressSound(LevelAccessor worldIn, BlockPos pos) {
        worldIn.playSound(null, pos, SoundEvents.ZOMBIE_DESTROY_EGG, SoundSource.HOSTILE, 0.5f, 0.9f + this.mob.getRandom().nextFloat() * 0.2f);
    }

    protected int nextStartTick(PathfinderMob mob) {
        return TameableAIDestroyTurtleEggs.reducedTickDelay((int)(800 + mob.getRandom().nextInt(800)));
    }

    public void playBreakSound(Level worldIn, BlockPos pos) {
        worldIn.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.random.nextFloat() * 0.2f);
    }

    public double acceptedDistance() {
        return 1.14;
    }
}

