/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityRaccoon;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class RaccoonAIBeg
extends Goal {
    private static final TargetingConditions ENTITY_PREDICATE = TargetingConditions.forNonCombat().range(32.0);
    protected final EntityRaccoon raccoon;
    private final double speed;
    protected Player closestPlayer;
    private int delayTemptCounter;
    private boolean isRunning;

    public RaccoonAIBeg(EntityRaccoon raccoon, double speed) {
        this.raccoon = raccoon;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        if (!this.raccoon.getMainHandItem().isEmpty()) {
            return false;
        }
        this.closestPlayer = this.raccoon.level().getNearestPlayer(ENTITY_PREDICATE, (LivingEntity)this.raccoon);
        if (this.closestPlayer == null) {
            return false;
        }
        boolean food = EntityRaccoon.isRaccoonFood(this.closestPlayer.getMainHandItem()) || EntityRaccoon.isRaccoonFood(this.closestPlayer.getOffhandItem());
        return food;
    }

    public boolean canContinueToUse() {
        return this.raccoon.getMainHandItem().isEmpty() && this.canUse();
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        this.closestPlayer = null;
        this.raccoon.getNavigation().stop();
        this.delayTemptCounter = 100;
        this.raccoon.setBegging(false);
        this.isRunning = false;
    }

    public void tick() {
        this.raccoon.getLookControl().setLookAt((Entity)this.closestPlayer, (float)(this.raccoon.getMaxHeadYRot() + 20), (float)this.raccoon.getMaxHeadXRot());
        if (this.raccoon.distanceToSqr((Entity)this.closestPlayer) < 12.0) {
            this.raccoon.getNavigation().stop();
            this.raccoon.setBegging(true);
        } else {
            this.raccoon.getNavigation().moveTo((Entity)this.closestPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

