/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityKomodoDragon;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class KomodoDragonAIJostle
extends Goal {
    private static final TargetingConditions JOSTLE_PREDICATE = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight();
    protected EntityKomodoDragon targetKomodoDragon;
    private final EntityKomodoDragon komodo;
    private final Level world;
    private float angle;

    public KomodoDragonAIJostle(EntityKomodoDragon moose) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.komodo = moose;
        this.world = moose.level();
    }

    public boolean canUse() {
        if (this.komodo.isJostling() || this.komodo.isInLove() || this.komodo.isOrderedToSit() || this.komodo.isVehicle() || this.komodo.shouldFollow() || this.komodo.isPassenger() || this.komodo.isBaby() || this.komodo.getTarget() != null || this.komodo.jostleCooldown > 0) {
            return false;
        }
        if (this.komodo.instantlyTriggerJostleAI || this.komodo.getRandom().nextInt(30) == 0) {
            this.komodo.instantlyTriggerJostleAI = false;
            if (this.komodo.getJostlingPartner() instanceof EntityKomodoDragon) {
                this.targetKomodoDragon = (EntityKomodoDragon)this.komodo.getJostlingPartner();
                return this.targetKomodoDragon.jostleCooldown == 0;
            }
            EntityKomodoDragon possiblePartner = this.getNearbyKomodoDragon();
            if (possiblePartner != null) {
                this.komodo.setJostlingPartner((Entity)possiblePartner);
                possiblePartner.setJostlingPartner((Entity)this.komodo);
                this.targetKomodoDragon = possiblePartner;
                this.targetKomodoDragon.instantlyTriggerJostleAI = true;
                return true;
            }
        }
        return false;
    }

    public void start() {
        this.komodo.jostleTimer = 0;
        this.angle = 0.0f;
        this.setJostleDirection(this.komodo.getRandom().nextBoolean());
    }

    public void setJostleDirection(boolean dir) {
        this.komodo.jostleDirection = dir;
        this.targetKomodoDragon.jostleDirection = dir;
    }

    public void stop() {
        this.komodo.setJostling(false);
        this.komodo.setJostlingPartner(null);
        this.komodo.jostleTimer = 0;
        this.angle = 0.0f;
        this.komodo.getNavigation().stop();
        if (this.targetKomodoDragon != null) {
            this.targetKomodoDragon.setJostling(false);
            this.targetKomodoDragon.setJostlingPartner(null);
            this.targetKomodoDragon.jostleTimer = 0;
            this.targetKomodoDragon = null;
        }
    }

    public void tick() {
        if (this.targetKomodoDragon != null) {
            this.komodo.lookAt((Entity)this.targetKomodoDragon, 360.0f, 180.0f);
            this.komodo.setJostling(true);
            float x = (float)(this.komodo.getX() - this.targetKomodoDragon.getX());
            float y = Math.abs((float)(this.komodo.getY() - this.targetKomodoDragon.getY()));
            float z = (float)(this.komodo.getZ() - this.targetKomodoDragon.getZ());
            double distXZ = Math.sqrt(x * x + z * z);
            if (distXZ < (double)1.8f) {
                this.komodo.getNavigation().stop();
                this.komodo.getMoveControl().strafe(-0.5f, 0.0f);
            } else if (distXZ > (double)2.4f) {
                this.komodo.setJostling(false);
                this.komodo.getNavigation().moveTo((Entity)this.targetKomodoDragon, 1.0);
            } else {
                this.komodo.lookAt((Entity)this.targetKomodoDragon, 360.0f, 180.0f);
                float f = this.komodo.getRandom().nextFloat() - 0.5f;
                if (this.komodo.jostleDirection) {
                    if (this.angle < 10.0f) {
                        this.angle += 1.0f;
                    } else {
                        this.komodo.jostleDirection = false;
                    }
                    this.komodo.getMoveControl().strafe(f * 1.0f, -0.4f);
                }
                if (!this.komodo.jostleDirection) {
                    if (this.angle > -10.0f) {
                        this.angle -= 1.0f;
                    } else {
                        this.komodo.jostleDirection = true;
                    }
                    this.komodo.getMoveControl().strafe(f * 1.0f, 0.4f);
                }
                if (this.komodo.getRandom().nextInt(15) == 0 && this.komodo.onGround()) {
                    this.komodo.pushBackJostling(this.targetKomodoDragon, 0.1f);
                }
                this.komodo.nextJostleAngleFromServer = this.angle;
                ++this.komodo.jostleTimer;
                ++this.targetKomodoDragon.jostleTimer;
                if (this.komodo.jostleTimer > 500 || y > 2.0f) {
                    this.komodo.hasImpulse = true;
                    if (this.komodo.onGround()) {
                        this.komodo.pushBackJostling(this.targetKomodoDragon, 0.4f);
                    }
                    if (this.targetKomodoDragon.onGround()) {
                        this.targetKomodoDragon.pushBackJostling(this.komodo, 0.4f);
                    }
                    this.komodo.jostleTimer = 0;
                    this.targetKomodoDragon.jostleTimer = 0;
                    this.komodo.jostleCooldown = 700 + this.komodo.getRandom().nextInt(2000);
                    this.targetKomodoDragon.jostleTimer = 0;
                    this.targetKomodoDragon.jostleCooldown = 700 + this.targetKomodoDragon.getRandom().nextInt(2000);
                    this.stop();
                }
            }
        }
    }

    public boolean canContinueToUse() {
        return !this.komodo.isBaby() && !this.komodo.isInLove() && !this.komodo.isVehicle() && !this.komodo.isOrderedToSit() && this.komodo.getTarget() == null && this.targetKomodoDragon != null && this.targetKomodoDragon.isAlive() && this.komodo.jostleCooldown == 0 && this.targetKomodoDragon.jostleCooldown == 0;
    }

    @Nullable
    private EntityKomodoDragon getNearbyKomodoDragon() {
        List komodoDragons = this.world.getNearbyEntities(EntityKomodoDragon.class, JOSTLE_PREDICATE, (LivingEntity)this.komodo, this.komodo.getBoundingBox().inflate(16.0));
        double lvt_2_1_ = Double.MAX_VALUE;
        EntityKomodoDragon lvt_4_1_ = null;
        for (EntityKomodoDragon lvt_6_1_ : komodoDragons) {
            if (!this.komodo.canJostleWith(lvt_6_1_) || !(this.komodo.distanceToSqr((Entity)lvt_6_1_) < lvt_2_1_)) continue;
            lvt_4_1_ = lvt_6_1_;
            lvt_2_1_ = this.komodo.distanceToSqr((Entity)lvt_6_1_);
        }
        return lvt_4_1_;
    }
}

