/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityGeladaMonkey;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class GeladaAIGroom
extends Goal {
    private final EntityGeladaMonkey monkey;
    private int groomTime = 0;
    private int groomCooldown = 220;
    private EntityGeladaMonkey beingGroomed;

    public GeladaAIGroom(EntityGeladaMonkey monkey) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.monkey = monkey;
    }

    public boolean canUse() {
        if (this.groomCooldown > 0) {
            --this.groomCooldown;
            return false;
        }
        this.groomCooldown = 200 + this.monkey.getRandom().nextInt(1000);
        EntityGeladaMonkey nearestMonkey = null;
        for (EntityGeladaMonkey entity : this.monkey.level().getEntitiesOfClass(EntityGeladaMonkey.class, this.monkey.getBoundingBox().inflate(15.0))) {
            if (entity.getId() == this.monkey.getId() || !this.monkey.canBeGroomed() || nearestMonkey != null && !(this.monkey.distanceTo((Entity)nearestMonkey) > this.monkey.distanceTo((Entity)entity))) continue;
            nearestMonkey = entity;
        }
        this.beingGroomed = nearestMonkey;
        return this.beingGroomed != null;
    }

    public boolean canContinueToUse() {
        return this.beingGroomed != null && this.beingGroomed.isAlive() && !this.beingGroomed.shouldStopBeingGroomed() && this.groomTime < 200 && (this.beingGroomed.groomerID == -1 || this.beingGroomed.groomerID == this.monkey.getId());
    }

    public void stop() {
        this.groomTime = 0;
        this.monkey.isGrooming = false;
        if (this.beingGroomed != null) {
            this.beingGroomed.groomerID = -1;
        }
        this.beingGroomed = null;
    }

    public void tick() {
        double dist = this.monkey.distanceTo((Entity)this.beingGroomed);
        if (dist < (double)(this.monkey.getBbWidth() + 0.5f)) {
            this.monkey.isGrooming = true;
            this.beingGroomed.groomerID = this.monkey.getId();
            this.monkey.setSitting(true);
            ++this.groomTime;
            if (this.groomTime % 50 == 0) {
                this.monkey.heal(1.0f);
            }
            if (this.monkey.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.monkey.setAnimation(EntityGeladaMonkey.ANIMATION_GROOM);
            }
            this.monkey.getNavigation().stop();
            this.monkey.lookAt((Entity)this.beingGroomed, 360.0f, 360.0f);
        } else {
            this.monkey.isGrooming = false;
            this.beingGroomed.groomerID = -1;
            this.monkey.setSitting(false);
            this.monkey.getNavigation().moveTo((Entity)this.beingGroomed, 1.0);
        }
    }
}

