/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityFroststalker;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FroststalkerAIMelee
extends Goal {
    private final EntityFroststalker froststalker;
    private boolean willJump = false;
    private boolean hasJumped = false;
    private boolean clockwise = false;
    private int pursuitTime = 0;
    private int maxPursuitTime = 0;
    private BlockPos pursuitPos = null;
    private int startingOrbit = 0;

    public FroststalkerAIMelee(EntityFroststalker froststalker) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.froststalker = froststalker;
    }

    public boolean canUse() {
        if (this.froststalker.getTarget() != null && this.froststalker.getTarget().isAlive()) {
            if (this.froststalker.isValidLeader(this.froststalker.getTarget())) {
                return this.froststalker.getLastHurtByMob() != null && this.froststalker.getLastHurtByMob().equals((Object)this.froststalker.getTarget());
            }
            return !this.froststalker.isFleeingFire();
        }
        return false;
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.froststalker.getTarget();
        return target != null && !this.froststalker.isValidLeader(target);
    }

    public void start() {
        this.willJump = this.froststalker.getRandom().nextInt(2) == 0;
        this.hasJumped = false;
        this.clockwise = this.froststalker.getRandom().nextBoolean();
        this.pursuitPos = null;
        this.pursuitTime = 0;
        this.maxPursuitTime = 40 + this.froststalker.getRandom().nextInt(40);
        this.startingOrbit = this.froststalker.getRandom().nextInt(360);
        this.froststalker.frostJump();
    }

    public void tick() {
        this.froststalker.setBipedal(true);
        this.froststalker.standFor(20);
        LivingEntity target = this.froststalker.getTarget();
        boolean flag = false;
        if ((this.hasJumped || this.froststalker.isTackling()) && this.froststalker.onGround()) {
            this.hasJumped = false;
            this.willJump = false;
            this.froststalker.setTackling(false);
        }
        if (target != null && target.isAlive()) {
            if (this.pursuitTime < this.maxPursuitTime) {
                ++this.pursuitTime;
                this.pursuitPos = this.getBlockNearTarget(target);
                float extraSpeed = 0.2f * Math.max(5.0f - this.froststalker.distanceTo((Entity)target), 0.0f);
                if (this.pursuitPos != null) {
                    this.froststalker.getNavigation().moveTo((double)this.pursuitPos.getX(), (double)this.pursuitPos.getY(), (double)this.pursuitPos.getZ(), (double)(1.0f + extraSpeed));
                } else {
                    this.froststalker.getNavigation().moveTo((Entity)target, 1.0);
                }
            } else if (this.willJump && this.pursuitTime == this.maxPursuitTime) {
                this.froststalker.lookAt((Entity)target, 180.0f, 10.0f);
                if (this.froststalker.distanceTo((Entity)target) > 10.0f) {
                    this.froststalker.getNavigation().moveTo((Entity)target, 1.0);
                } else if (this.froststalker.onGround() && this.froststalker.hasLineOfSight((Entity)target)) {
                    this.froststalker.setTackling(true);
                    this.hasJumped = true;
                    Vec3 vector3d = this.froststalker.getDeltaMovement();
                    Vec3 vector3d1 = new Vec3(target.getX() - this.froststalker.getX(), 0.0, target.getZ() - this.froststalker.getZ());
                    if (vector3d1.lengthSqr() > 1.0E-7) {
                        vector3d1 = vector3d1.normalize().scale(0.9).add(vector3d.scale(0.8));
                    }
                    this.froststalker.setDeltaMovement(vector3d1.x, 0.6f, vector3d1.z);
                } else {
                    flag = true;
                }
            } else if (!this.froststalker.isTackling()) {
                this.froststalker.getNavigation().moveTo((Entity)target, 1.0);
            }
            if (this.froststalker.isTackling() && this.froststalker.distanceTo((Entity)target) <= this.froststalker.getBbWidth() + target.getBbWidth() + 1.1f && this.froststalker.hasLineOfSight((Entity)target)) {
                target.hurt(this.froststalker.damageSources().mobAttack((LivingEntity)this.froststalker), (float)this.froststalker.getAttributeValue(Attributes.ATTACK_DAMAGE));
                this.start();
            }
            if (!flag && this.froststalker.distanceTo((Entity)target) <= this.froststalker.getBbWidth() + target.getBbWidth() + 1.1f && this.froststalker.hasLineOfSight((Entity)target) && this.pursuitTime == this.maxPursuitTime) {
                if (!this.froststalker.isTackling()) {
                    this.froststalker.doHurtTarget((Entity)target);
                }
                this.start();
            }
        }
        if (target != null && !this.froststalker.onGround()) {
            this.froststalker.lookAt((Entity)target, 180.0f, 10.0f);
            this.froststalker.yBodyRot = this.froststalker.getYRot();
        }
    }

    public BlockPos getBlockNearTarget(LivingEntity target) {
        float radius = (float)(this.froststalker.getRandom().nextInt(5) + 3) + target.getBbWidth();
        int orbit = (int)((float)this.startingOrbit + (float)this.pursuitTime / (float)this.maxPursuitTime * 360.0f);
        float angle = (float)Math.PI / 180 * (float)(this.clockwise ? -orbit : orbit);
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos circlePos = AMBlockPos.fromCoords(target.getX() + extraX, target.getEyeY(), target.getZ() + extraZ);
        while (!this.froststalker.level().getBlockState(circlePos).isAir() && circlePos.getY() < this.froststalker.level().getMaxBuildHeight()) {
            circlePos = circlePos.above();
        }
        while (!this.froststalker.level().getBlockState(circlePos.below()).entityCanStandOn((BlockGetter)this.froststalker.level(), circlePos.below(), (Entity)this.froststalker) && circlePos.getY() > 1) {
            circlePos = circlePos.below();
        }
        if (this.froststalker.getWalkTargetValue(circlePos) > -1.0f) {
            return circlePos;
        }
        return null;
    }

    public void stop() {
        this.froststalker.setTackling(false);
    }
}

