/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public class EtherealMoveController
extends MoveControl {
    private final Mob parentEntity;
    private final float speedGeneral;

    public EtherealMoveController(Mob parentEntity, float speedGeneral) {
        super(parentEntity);
        this.parentEntity = parentEntity;
        this.speedGeneral = speedGeneral;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
            double d0 = vector3d.length();
            this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d.scale(this.speedModifier * (double)this.speedGeneral * 0.025 / d0)));
            double yAdd = this.wantedY - this.parentEntity.getY();
            if (d0 > (double)this.parentEntity.getBbWidth()) {
                this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(0.0, (double)this.parentEntity.getSpeed() * (double)this.speedGeneral * Mth.clamp((double)yAdd, (double)-1.0, (double)1.0) * (double)0.6f, 0.0));
                Vec3 vector3d1 = this.parentEntity.getDeltaMovement();
                this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                this.parentEntity.yBodyRot = this.parentEntity.getYRot();
            }
        } else if (this.operation == MoveControl.Operation.STRAFE || this.operation == MoveControl.Operation.JUMPING) {
            this.operation = MoveControl.Operation.WAIT;
        }
    }
}

