/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityCrow;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CrowAIMelee
extends Goal {
    private final EntityCrow crow;
    float circlingTime = 0.0f;
    float circleDistance = 1.0f;
    float yLevel = 2.0f;
    boolean clockwise = false;
    private int maxCircleTime;

    public CrowAIMelee(EntityCrow crow) {
        this.crow = crow;
    }

    public boolean canUse() {
        return this.crow.getTarget() != null && !this.crow.isSitting() && this.crow.getCommand() != 3;
    }

    public void start() {
        this.clockwise = this.crow.getRandom().nextBoolean();
        this.yLevel = this.crow.getRandom().nextInt(2);
        this.circlingTime = 0.0f;
        this.maxCircleTime = 20 + this.crow.getRandom().nextInt(100);
        this.circleDistance = 1.0f + this.crow.getRandom().nextFloat() * 3.0f;
    }

    public void stop() {
        this.clockwise = this.crow.getRandom().nextBoolean();
        this.yLevel = this.crow.getRandom().nextInt(2);
        this.circlingTime = 0.0f;
        this.maxCircleTime = 20 + this.crow.getRandom().nextInt(100);
        this.circleDistance = 1.0f + this.crow.getRandom().nextFloat() * 3.0f;
        if (this.crow.onGround()) {
            this.crow.setFlying(false);
        }
    }

    public void tick() {
        LivingEntity target = this.crow.getTarget();
        if (target != null) {
            if (this.circlingTime > (float)this.maxCircleTime) {
                this.crow.getMoveControl().setWantedPosition(target.getX(), target.getY() + (double)(target.getEyeHeight() / 2.0f), target.getZ(), (double)1.3f);
                if (this.crow.distanceTo((Entity)target) < 2.0f) {
                    this.crow.peck();
                    if (target.getType().is(EntityTypeTags.ARTHROPOD)) {
                        target.hurt(target.damageSources().generic(), 4.0f);
                    } else {
                        target.hurt(target.damageSources().generic(), 1.0f);
                    }
                    this.stop();
                }
            } else {
                Vec3 circlePos = this.getVultureCirclePos(target.position());
                if (circlePos == null) {
                    circlePos = target.position();
                }
                this.crow.setFlying(true);
                this.crow.getMoveControl().setWantedPosition(circlePos.x(), circlePos.y() + (double)target.getEyeHeight() + (double)0.2f, circlePos.z(), 1.0);
            }
        }
        if (this.crow.isFlying()) {
            this.circlingTime += 1.0f;
        }
    }

    public Vec3 getVultureCirclePos(Vec3 target) {
        float angle = 0.13962634f * (this.clockwise ? -this.circlingTime : this.circlingTime);
        double extraX = this.circleDistance * Mth.sin((float)angle);
        double extraZ = this.circleDistance * Mth.cos((float)angle);
        Vec3 pos = new Vec3(target.x() + extraX, target.y() + (double)this.yLevel, target.z() + extraZ);
        if (this.crow.level().isEmptyBlock(AMBlockPos.fromVec3(pos))) {
            return pos;
        }
        return null;
    }
}

