/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityCapuchinMonkey;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;

public class CapuchinAITargetBalloons
extends Goal {
    private final EntityCapuchinMonkey monkey;
    protected final boolean shouldCheckSight;
    private final boolean nearbyOnly;
    private int targetSearchStatus;
    private int targetSearchDelay;
    private int targetUnseenTicks;
    protected Entity target;
    protected int unseenMemoryTicks = 60;
    protected final int targetChance;
    public static final Predicate<Entity> TARGET_BLOON = balloon -> balloon.getEncodeId() != null && (balloon.getType().is(AMTagRegistry.MONKEY_TARGET_WITH_DART) || balloon.getEncodeId().contains("balloom"));

    public CapuchinAITargetBalloons(EntityCapuchinMonkey mobIn, boolean checkSight) {
        this(mobIn, checkSight, false, 40);
    }

    public CapuchinAITargetBalloons(EntityCapuchinMonkey mobIn, boolean checkSight, boolean nearbyOnlyIn, int targetChance) {
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.monkey = mobIn;
        this.shouldCheckSight = checkSight;
        this.nearbyOnly = nearbyOnlyIn;
        this.targetChance = targetChance;
    }

    public boolean canUse() {
        if (this.targetChance > 0 && this.monkey.getRandom().nextInt(this.targetChance) != 0) {
            return false;
        }
        this.findNearestTarget();
        return this.target != null;
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.monkey.getBoundingBox().inflate(targetDistance, targetDistance, targetDistance);
    }

    protected void findNearestTarget() {
        Entity closest = null;
        for (Entity bloon : this.monkey.level().getEntitiesOfClass(Entity.class, this.getTargetableArea(this.getTargetDistance()), TARGET_BLOON)) {
            if (closest != null && !(closest.distanceTo((Entity)this.monkey) > bloon.distanceTo((Entity)this.monkey))) continue;
            closest = bloon;
        }
        this.target = closest;
    }

    public boolean canContinueToUse() {
        Entity livingentity = this.monkey.getDartTarget();
        if (livingentity == null) {
            livingentity = this.target;
        }
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        PlayerTeam team = this.monkey.getTeam();
        PlayerTeam team1 = livingentity.getTeam();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getTargetDistance();
        if (this.monkey.distanceToSqr(livingentity) > d0 * d0) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.monkey.getSensing().hasLineOfSight(livingentity)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) {
                return false;
            }
        }
        if (livingentity instanceof Player && ((Player)livingentity).getAbilities().invulnerable) {
            return false;
        }
        this.monkey.setDartTarget(livingentity);
        return true;
    }

    protected double getTargetDistance() {
        return this.monkey.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    public void start() {
        this.monkey.setDartTarget(this.target);
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.targetUnseenTicks = 0;
    }

    public void stop() {
        this.monkey.setTarget(null);
        this.monkey.setDartTarget(null);
        this.target = null;
    }

    protected boolean isSuitableTarget(@Nullable LivingEntity potentialTarget, TargetingConditions targetPredicate) {
        if (potentialTarget == null) {
            return false;
        }
        if (!targetPredicate.test((LivingEntity)this.monkey, potentialTarget)) {
            return false;
        }
        if (!this.monkey.isWithinRestriction(potentialTarget.blockPosition())) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.canEasilyReach(potentialTarget) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canEasilyReach(LivingEntity target) {
        int j;
        this.targetSearchDelay = 10 + this.monkey.getRandom().nextInt(5);
        Path path = this.monkey.getNavigation().createPath((Entity)target, 0);
        if (path == null) {
            return false;
        }
        Node pathpoint = path.getEndNode();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.x - Mth.floor((double)target.getX());
        return (double)(i * i + (j = pathpoint.z - Mth.floor((double)target.getZ())) * j) <= 2.25;
    }

    public CapuchinAITargetBalloons setUnseenMemoryTicks(int unseenMemoryTicksIn) {
        this.unseenMemoryTicks = unseenMemoryTicksIn;
        return this;
    }
}

