/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityCaiman;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class CaimanAIBellow
extends Goal {
    private final EntityCaiman caiman;
    private int bellowTime = 0;

    public CaimanAIBellow(EntityCaiman caiman) {
        this.caiman = caiman;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.caiman.getTarget() == null && this.caiman.bellowCooldown <= 0 && this.caiman.isInWaterOrBubble() && !this.caiman.shouldFollow();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.bellowTime < 60;
    }

    public void stop() {
        this.bellowTime = 0;
        this.caiman.bellowCooldown = 1000 + this.caiman.getRandom().nextInt(1000);
        this.caiman.setBellowing(false);
    }

    public void tick() {
        if (this.caiman.isInWaterOrBubble()) {
            double d1 = this.caiman.getFluidTypeHeight((FluidType)NeoForgeMod.WATER_TYPE.value());
            this.caiman.getNavigation().stop();
            if (d1 > (double)0.3f) {
                double d2 = Math.pow(d1 - (double)0.3f, 2.0);
                this.caiman.setDeltaMovement(new Vec3(this.caiman.getDeltaMovement().x, Math.min(d2 * (double)0.08f, (double)0.04f), this.caiman.getDeltaMovement().z));
            } else {
                this.caiman.setDeltaMovement(new Vec3(this.caiman.getDeltaMovement().x, (double)-0.02f, this.caiman.getDeltaMovement().z));
            }
            if (d1 > (double)0.19f && d1 < 0.5) {
                ++this.bellowTime;
                this.caiman.playSound((SoundEvent)AMSoundRegistry.CAIMAN_SPLASH.get(), 1.0f, this.caiman.getVoicePitch());
                this.caiman.setBellowing(true);
            }
        }
    }
}

