/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityKangaroo;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class AnimalAIWanderRanged
extends RandomStrollGoal {
    protected final float probability;
    protected final int xzRange;
    protected final int yRange;

    public AnimalAIWanderRanged(PathfinderMob creature, int chance, double speedIn, int xzRange, int yRange) {
        this(creature, chance, speedIn, 0.001f, xzRange, yRange);
    }

    public boolean canUse() {
        Vec3 lvt_1_1_;
        if (this.mob.isVehicle() && !(this.mob instanceof EntityKangaroo)) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.mob.getNoActionTime() >= 100) {
                return false;
            }
            if (this.mob.getRandom().nextInt(this.interval) != 0) {
                return false;
            }
        }
        if ((lvt_1_1_ = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = lvt_1_1_.x;
        this.wantedY = lvt_1_1_.y;
        this.wantedZ = lvt_1_1_.z;
        this.forceTrigger = false;
        return true;
    }

    public AnimalAIWanderRanged(PathfinderMob creature, int chance, double speedIn, float probabilityIn, int xzRange, int yRange) {
        super(creature, speedIn, chance);
        this.probability = probabilityIn;
        this.xzRange = xzRange;
        this.yRange = yRange;
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.mob.isInWaterOrBubble()) {
            Vec3 vector3d = LandRandomPos.getPos((PathfinderMob)this.mob, (int)this.xzRange, (int)this.yRange);
            return vector3d == null ? super.getPosition() : vector3d;
        }
        return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)this.xzRange, (int)this.yRange) : super.getPosition();
    }
}

