/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;

public class AnimalAIRideParent
extends Goal {
    private final Animal childAnimal;
    private Animal parentAnimal;
    private final double moveSpeed;
    private int delayCounter;

    public AnimalAIRideParent(Animal animal, double speed) {
        this.childAnimal = animal;
        this.moveSpeed = speed;
    }

    public boolean canUse() {
        if (this.childAnimal.getAge() >= 0 || this.childAnimal.isPassenger()) {
            return false;
        }
        List list = this.childAnimal.level().getEntitiesOfClass(this.childAnimal.getClass(), this.childAnimal.getBoundingBox().inflate(8.0, 4.0, 8.0));
        Animal animalentity = null;
        double d0 = Double.MAX_VALUE;
        for (Animal animalentity1 : list) {
            double d1;
            if (animalentity1.getAge() < 0 || !animalentity1.getPassengers().isEmpty() || (d1 = this.childAnimal.distanceToSqr((Entity)animalentity1)) > d0) continue;
            d0 = d1;
            animalentity = animalentity1;
        }
        if (animalentity == null) {
            return false;
        }
        if (d0 < 2.0) {
            return false;
        }
        this.parentAnimal = animalentity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.childAnimal.getAge() >= 0) {
            return false;
        }
        if (this.parentAnimal == null || !this.parentAnimal.isAlive() || !this.parentAnimal.getPassengers().isEmpty()) {
            return false;
        }
        double d0 = this.childAnimal.distanceToSqr((Entity)this.parentAnimal);
        return !(d0 < 2.0) && !(d0 > 256.0) && !this.childAnimal.isPassengerOfSameVehicle((Entity)this.parentAnimal);
    }

    public void start() {
        this.delayCounter = 0;
    }

    public void stop() {
        this.parentAnimal = null;
    }

    public void tick() {
        if (--this.delayCounter <= 0) {
            this.delayCounter = 10;
            this.childAnimal.getNavigation().moveTo((Entity)this.parentAnimal, this.moveSpeed);
        }
        if ((double)this.childAnimal.distanceTo((Entity)this.parentAnimal) < 2.0) {
            this.childAnimal.startRiding((Entity)this.parentAnimal, false);
            this.stop();
        }
    }
}

