/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.EntityRaccoon;
import com.github.alexthe666.alexsmobs.entity.ai.ILootsChests;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class AnimalAILootChests
extends MoveToBlockGoal {
    private final Animal entity;
    private final ILootsChests chestLooter;
    private boolean hasOpenedChest = false;

    public AnimalAILootChests(Animal entity, int range) {
        super((PathfinderMob)entity, 1.0, range);
        this.entity = entity;
        this.chestLooter = (ILootsChests)entity;
    }

    public boolean isChestRaidable(LevelReader world, BlockPos pos) {
        if (world.getBlockState(pos).getBlock() instanceof BaseEntityBlock) {
            Block block = world.getBlockState(pos).getBlock();
            boolean listed = false;
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof Container) {
                Container inventory = (Container)entity;
                try {
                    if (!inventory.isEmpty() && this.chestLooter.isLootable(inventory)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    AlexsMobs.LOGGER.warn("Alex's Mobs stopped a " + entity.getClass().getSimpleName() + " from causing a crash during access");
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public boolean canUse() {
        if (this.entity instanceof TamableAnimal && ((TamableAnimal)this.entity).isTame()) {
            return false;
        }
        if (!AMConfig.raccoonsStealFromChests) {
            return false;
        }
        if (!this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            return false;
        }
        if (this.nextStartTick <= 0 && !EventHooks.canEntityGrief((Level)this.entity.level(), (Entity)this.entity)) {
            return false;
        }
        return super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty();
    }

    public boolean hasLineOfSightChest() {
        BlockHitResult raytraceresult = this.entity.level().clip(new ClipContext(this.entity.getEyePosition(1.0f), new Vec3((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY() + 0.5, (double)this.blockPos.getZ() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity));
        if (raytraceresult instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = raytraceresult;
            BlockPos pos = blockRayTraceResult.getBlockPos();
            return pos.equals((Object)this.blockPos) || this.entity.level().isEmptyBlock(pos) || this.entity.level().getBlockEntity(pos) == this.entity.level().getBlockEntity(this.blockPos);
        }
        return true;
    }

    public ItemStack getFoodFromInventory(Container inventory, RandomSource random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!this.chestLooter.shouldLootItem(stack)) continue;
            items.add(stack);
        }
        if (items.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (items.size() == 1) {
            return (ItemStack)items.get(0);
        }
        return (ItemStack)items.get(random.nextInt(items.size() - 1));
    }

    public void tick() {
        super.tick();
        if (this.blockPos == null) {
            return;
        }
        BlockEntity te = this.entity.level().getBlockEntity(this.blockPos);
        if (te instanceof Container) {
            Container feeder = (Container)te;
            double distance = this.entity.distanceToSqr((double)((float)this.blockPos.getX() + 0.5f), (double)((float)this.blockPos.getY() + 0.5f), (double)((float)this.blockPos.getZ() + 0.5f));
            if (this.hasLineOfSightChest()) {
                if (this.isReachedTarget() && distance <= 3.0) {
                    this.toggleChest(feeder, false);
                    ItemStack stack = this.getFoodFromInventory(feeder, this.entity.level().random);
                    if (stack == ItemStack.EMPTY) {
                        this.stop();
                    } else {
                        ItemStack duplicate = stack.copy();
                        duplicate.setCount(1);
                        if (!this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.entity.level().isClientSide) {
                            this.entity.spawnAtLocation(this.entity.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
                        }
                        this.entity.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
                        if (this.entity instanceof EntityRaccoon) {
                            ((EntityRaccoon)this.entity).lookForWaterBeforeEatingTimer = 10;
                        }
                        stack.shrink(1);
                        this.stop();
                    }
                } else if (distance < 5.0 && !this.hasOpenedChest) {
                    this.hasOpenedChest = true;
                    this.toggleChest(feeder, true);
                }
            }
        }
    }

    public void stop() {
        BlockEntity te;
        super.stop();
        if (this.blockPos != null && (te = this.entity.level().getBlockEntity(this.blockPos)) instanceof Container) {
            this.toggleChest((Container)te, false);
        }
        this.blockPos = BlockPos.ZERO;
        this.hasOpenedChest = false;
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        return pos != null && this.isChestRaidable(worldIn, pos);
    }

    public void toggleChest(Container te, boolean open) {
        if (te instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)te;
            if (open) {
                this.entity.level().blockEvent(this.blockPos, chest.getBlockState().getBlock(), 1, 1);
            } else {
                this.entity.level().blockEvent(this.blockPos, chest.getBlockState().getBlock(), 1, 0);
            }
            this.entity.level().updateNeighborsAt(this.blockPos, chest.getBlockState().getBlock());
            this.entity.level().updateNeighborsAt(this.blockPos.below(), chest.getBlockState().getBlock());
        }
    }
}

